/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.core.CleanUpHandler;
import adams.core.Properties;
import adams.core.Range;
import adams.core.StatusMessageHandler;
import adams.core.io.PlaceholderFile;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.SearchPanel;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.report.ReportContainerList;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.spreadsheet.AbstractSpreadSheetRowPaintlet;
import adams.gui.visualization.spreadsheet.HistogramFactory;
import adams.gui.visualization.spreadsheet.LoadSpreadSheetDialog;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainer;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainerList;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainerManager;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPanel;
import adams.gui.visualization.spreadsheet.SpreadSheetRowReportFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class SpreadSheetExplorer
extends BasePanel
implements MenuBarProvider,
StatusMessageHandler,
ContainerListManager<SpreadSheetRowContainerManager>,
DataChangeListener,
CleanUpHandler,
SendToActionSupporter {
    private static final long serialVersionUID = 4478483903068117980L;
    public static final String FILENAME = "SpreadSheetExplorer.props";
    public static final String SESSION_FILE = "SpreadSheetExplorerSession.props";
    protected static Properties m_Properties;
    protected SpreadSheetRowPanel m_PanelInstance;
    protected BaseStatusBar m_StatusBar;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuItemLoadRecent;
    protected JMenu m_MenuView;
    protected JMenuItem m_MenuItemViewZoomOverview;
    protected JMenuItem m_MenuItemViewAntiAliasing;
    protected JMenuItem m_MenuItemViewColorProvider;
    protected JMenuItem m_MenuItemViewPaintlet;
    protected JMenuItem m_MenuItemClearData;
    protected BaseTabbedPane m_TabbedPane;
    protected ReportFactory.Panel m_Reports;
    protected SearchPanel m_SearchPanel;
    protected LoadSpreadSheetDialog m_LoadFromDiskDialog;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected HistogramFactory.SetupDialog m_HistogramSetup;
    protected GenericObjectEditorDialog m_DialogColorProvider;
    protected GenericObjectEditorDialog m_DialogPaintlet;

    protected void initialize() {
        super.initialize();
        this.m_LoadFromDiskDialog = null;
        this.m_RecentFilesHandler = null;
        this.m_HistogramSetup = null;
        this.m_DialogColorProvider = null;
        this.m_DialogPaintlet = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        JPanel panelData = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Data", (Component)panelData);
        this.m_TabbedPane.addChangeListener(e -> {
            ContainerTable dtable = this.getSpreadSheetRowContainerList().getTable();
            if (this.m_TabbedPane.getSelectedIndex() == 0) {
                ContainerTable rtable = this.m_Reports.getReportContainerList().getTable();
                if (rtable == null || rtable.getSelectedRowCount() != 1) {
                    return;
                }
                int row = rtable.getSelectedRow();
                dtable.getSelectionModel().clearSelection();
                dtable.getSelectionModel().setSelectionInterval(row, row);
            } else if (this.m_TabbedPane.getSelectedIndex() == 1) {
                if (dtable.getSelectedRowCount() != 1) {
                    return;
                }
                this.m_Reports.setCurrentTable(dtable.getSelectedRow());
            }
        });
        this.m_PanelInstance = new SpreadSheetRowPanel();
        ((SpreadSheetRowContainerManager)this.m_PanelInstance.getContainerManager()).addDataChangeListener(this);
        this.m_PanelInstance.setStatusMessageHandler(this);
        panelData.add((Component)((Object)this.m_PanelInstance), "Center");
        JPanel panelReports = new JPanel(new BorderLayout());
        this.m_TabbedPane.addTab("Information", (Component)panelReports);
        this.m_Reports = this.newReportPanel();
        this.m_Reports.setDataContainerPanel((DataContainerPanel)this.m_PanelInstance);
        panelReports.add((Component)this.m_Reports, "Center");
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
        this.m_SearchPanel.addSearchListener(e -> {
            this.m_Reports.search(this.m_SearchPanel.getSearchText(), this.m_SearchPanel.isRegularExpression());
            this.m_SearchPanel.grabFocus();
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_SearchPanel, "West");
        panelReports.add((Component)panel, "South");
        this.m_StatusBar = new BaseStatusBar();
        this.add((Component)this.m_StatusBar, "South");
    }

    public SpreadSheetRowPanel getSpreadSheetRowPanel() {
        return this.m_PanelInstance;
    }

    public SpreadSheetRowContainerList getSpreadSheetRowContainerList() {
        return (SpreadSheetRowContainerList)this.m_PanelInstance.getContainerList();
    }

    public void showStatus(String msg) {
        this.m_StatusBar.showStatus(msg);
    }

    protected SpreadSheetRowReportFactory.Panel newReportPanel() {
        return new SpreadSheetRowReportFactory.Panel();
    }

    public void dataChanged(DataChangeEvent e) {
        this.updateMenu();
    }

    public SpreadSheetRowContainerManager getContainerManager() {
        return (SpreadSheetRowContainerManager)this.m_PanelInstance.getContainerManager();
    }

    public void setContainerManager(SpreadSheetRowContainerManager value) {
        this.m_PanelInstance.setContainerManager(value);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean dataLoaded = this.getContainerManager().count() > 0;
        this.m_MenuItemClearData.setEnabled(dataLoaded);
        this.m_MenuItemLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemViewAntiAliasing.setSelected(this.getSpreadSheetRowPanel().isAntiAliasingEnabled());
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("Clear");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed N"));
            menuitem.setIcon(GUIHelper.getIcon((String)"new.gif"));
            menuitem.addActionListener(e -> this.clearData());
            this.m_MenuItemClearData = menuitem;
            menu.addSeparator();
            menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('o');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(e -> this.loadData());
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, SpreadSheetExplorer.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    SpreadSheetExplorer.this.loadData((File)e.getItem());
                }
            });
            this.m_MenuItemLoadRecent = submenu;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(e -> this.close());
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(e -> this.updateMenu());
            this.m_MenuView = menu;
            menuitem = new JCheckBoxMenuItem("Display zoom overview");
            menu.add(menuitem);
            menuitem.setMnemonic('Z');
            menuitem.setSelected(this.isZoomOverviewPanelVisible());
            menuitem.addActionListener(e -> this.setZoomOverviewPanelVisible(this.m_MenuItemViewZoomOverview.isSelected()));
            this.m_MenuItemViewZoomOverview = menuitem;
            menuitem = new JCheckBoxMenuItem("Anti-aliasing");
            menu.add(menuitem);
            menuitem.setMnemonic('A');
            menuitem.setSelected(this.getSpreadSheetRowPanel().isAntiAliasingEnabled());
            menuitem.addActionListener(e -> this.getSpreadSheetRowPanel().setAntiAliasingEnabled(this.m_MenuItemViewAntiAliasing.isSelected()));
            this.m_MenuItemViewAntiAliasing = menuitem;
            menuitem = new JMenuItem("Color provider...");
            menu.add(menuitem);
            menuitem.setMnemonic('d');
            menuitem.addActionListener(e -> this.selectColorProvider());
            this.m_MenuItemViewColorProvider = menuitem;
            menuitem = new JMenuItem("Paintlet...");
            menu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(e -> this.selectPaintlet());
            this.m_MenuItemViewPaintlet = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void clearData() {
        this.getContainerManager().clear();
    }

    public void loadData() {
        this.loadData(null);
    }

    public void loadData(File file) {
        if (this.m_LoadFromDiskDialog == null) {
            this.m_LoadFromDiskDialog = this.getParentDialog() != null ? new LoadSpreadSheetDialog(this.getParentDialog()) : new LoadSpreadSheetDialog(this.getParentFrame());
            this.m_LoadFromDiskDialog.setCurrent(new File(SpreadSheetExplorer.getProperties().getPath("InitialDir", "%h")));
            this.m_LoadFromDiskDialog.setDefaultAttributeRange(SpreadSheetExplorer.getProperties().getPath("AttributeRange", "first-last"));
            this.m_LoadFromDiskDialog.setDefaultSortIndex(SpreadSheetExplorer.getProperties().getPath("SortIndex", ""));
            this.m_LoadFromDiskDialog.setAcceptListener(e -> {
                int[] indices = this.m_LoadFromDiskDialog.getIndices();
                if (indices == null) {
                    return;
                }
                if (this.m_RecentFilesHandler != null) {
                    this.m_RecentFilesHandler.addRecentItem((Object)this.m_LoadFromDiskDialog.getCurrent());
                }
                this.showStatus("Loading data...");
                ArrayList<SpreadSheetRowContainer> data = new ArrayList<SpreadSheetRowContainer>();
                SpreadSheet sheet = this.m_LoadFromDiskDialog.getSpreadSheet();
                int[] additional = this.m_LoadFromDiskDialog.getAdditionalAttributes();
                Range range = this.m_LoadFromDiskDialog.getCurrentAttributeRange();
                int id = this.m_LoadFromDiskDialog.getCurrentIDIndex();
                HashSet<Integer> attTypes = null;
                for (int i = 0; i < indices.length; ++i) {
                    DataRow srow = sheet.getRow(indices[i]);
                    SpreadSheetRow row = new SpreadSheetRow();
                    row.set((Row)srow, i, additional, range, attTypes);
                    if (id == -1) {
                        row.setID(indices[i] + 1 + "." + (sheet.getName() != null ? sheet.getName() : "sheet"));
                    } else {
                        row.setID(srow.getCell(id).getContent());
                    }
                    data.add(this.getContainerManager().newContainer((Comparable)((Object)row)));
                    this.showStatus("Loading data " + (i + 1) + "/" + sheet.getRowCount());
                }
                this.loadData(sheet, data);
                this.showStatus("");
            });
        }
        if (file != null) {
            this.m_LoadFromDiskDialog.setCurrent(file);
        }
        this.m_LoadFromDiskDialog.setVisible(true);
    }

    protected void loadData(SpreadSheet sheet, List<SpreadSheetRowContainer> data) {
        if (this.getContainerManager().count() + data.size() > SpreadSheetExplorer.getProperties().getInteger("MaxNumContainersWithAntiAliasing", Integer.valueOf(50)) && this.getSpreadSheetRowPanel().isAntiAliasingEnabled()) {
            this.getSpreadSheetRowPanel().setAntiAliasingEnabled(false);
        }
        SpreadSheetRowContainerList listInst = (SpreadSheetRowContainerList)this.m_PanelInstance.getContainerList();
        ReportContainerList listReport = this.m_Reports.getReportContainerList();
        listInst.setDisplayDatabaseID(false);
        listReport.setDisplayDatabaseID(false);
        this.getContainerManager().addAll(data);
    }

    public void close() {
        this.cleanUp();
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    public void setSidePanelVisible(boolean visible) {
        this.m_PanelInstance.setSidePanelVisible(visible);
    }

    public boolean isSidePanelVisible() {
        return this.m_PanelInstance.isSidePanelVisible();
    }

    public JPanel getSidePanel() {
        return this.m_PanelInstance.getSidePanel();
    }

    public void setZoomOverviewPanelVisible(boolean value) {
        this.m_PanelInstance.setZoomOverviewPanelVisible(value);
    }

    public boolean isZoomOverviewPanelVisible() {
        return this.m_PanelInstance.isZoomOverviewPanelVisible();
    }

    protected void selectColorProvider() {
        if (this.m_DialogColorProvider == null) {
            this.m_DialogColorProvider = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_DialogColorProvider.setTitle("Select color provider");
            this.m_DialogColorProvider.getGOEEditor().setClassType(AbstractColorProvider.class);
            this.m_DialogColorProvider.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_DialogColorProvider.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_DialogColorProvider.setCurrent((Object)this.getContainerManager().getColorProvider().shallowCopy());
        this.m_DialogColorProvider.setVisible(true);
        if (this.m_DialogColorProvider.getResult() != 0) {
            return;
        }
        this.getContainerManager().setColorProvider(((AbstractColorProvider)this.m_DialogColorProvider.getCurrent()).shallowCopy());
    }

    protected void selectPaintlet() {
        if (this.m_DialogPaintlet == null) {
            this.m_DialogPaintlet = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_DialogPaintlet.setTitle("Select paintlet");
            this.m_DialogPaintlet.getGOEEditor().setClassType(AbstractSpreadSheetRowPaintlet.class);
            this.m_DialogPaintlet.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_DialogPaintlet.setLocationRelativeTo((Component)((Object)this));
        }
        this.m_DialogPaintlet.setCurrent(this.getSpreadSheetRowPanel().getDataPaintlet().shallowCopy());
        this.m_DialogPaintlet.setVisible(true);
        if (this.m_DialogPaintlet.getResult() != 0) {
            return;
        }
        Paintlet paintlet = (Paintlet)this.m_DialogPaintlet.getCurrent();
        paintlet.setPanel((PaintablePanel)this.getSpreadSheetRowPanel());
        this.getSpreadSheetRowPanel().removePaintlet(this.getSpreadSheetRowPanel().getDataPaintlet());
        this.getSpreadSheetRowPanel().addPaintlet(paintlet);
        boolean zoomVisible = this.getSpreadSheetRowPanel().isZoomOverviewPanelVisible();
        this.getSpreadSheetRowPanel().getZoomOverviewPanel().setDataContainerPanel((DataContainerPanel)this.getSpreadSheetRowPanel());
        this.getSpreadSheetRowPanel().setZoomOverviewPanelVisible(zoomVisible);
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JComponent.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return this.getContainerManager().countVisible() > 0;
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            if (this.getContainerManager().countVisible() > 0) {
                result = SendToActionUtils.nextTmpFile((String)"spreadsheetexplorer", (String)"csv");
                CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
                SpreadSheet sheet = this.m_PanelInstance.getSpreadSheet();
                if (!writer.write(sheet, (File)result)) {
                    GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write spreadsheet to '" + result + "'!"));
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, (Class[])cls) && this.getContainerManager().countVisible() > 0) {
            result = this;
        }
        return result;
    }

    public void cleanUp() {
        this.m_PanelInstance.cleanUp();
        if (this.m_DialogColorProvider != null) {
            this.m_DialogColorProvider.dispose();
            this.m_DialogColorProvider = null;
        }
        if (this.m_DialogPaintlet != null) {
            this.m_DialogPaintlet.dispose();
            this.m_DialogPaintlet = null;
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("spreadsheet explorer");
        }
        return m_Properties;
    }
}

