/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.RenameSpreadSheetColumn;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class RenameSpreadSheetColumnTest
extends AbstractConversionTestCase {
    public RenameSpreadSheetColumnTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("bolts.csv");
        try {
            result = new SpreadSheet[]{new CsvSpreadSheetReader().read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            RenameSpreadSheetColumnTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        RenameSpreadSheetColumn[] result = new RenameSpreadSheetColumn[]{new RenameSpreadSheetColumn(), new RenameSpreadSheetColumn()};
        result[1].setColumn(new SpreadSheetColumnIndex("2"));
        result[1].setNewName("blahblah");
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(RenameSpreadSheetColumnTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        RenameSpreadSheetColumnTest.runTest((Test)RenameSpreadSheetColumnTest.suite());
    }
}

