/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.DateFormatString;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetToNumeric;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetToNumericTest
extends AbstractConversionTestCase {
    public SpreadSheetToNumericTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("labor.csv");
        this.m_TestHelper.copyResourceToTmp("date.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("labor.csv");
        this.m_TestHelper.deleteFileFromTmp("date.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        CsvSpreadSheetReader reader;
        Object[] result = new SpreadSheet[2];
        TmpFile file = new TmpFile("labor.csv");
        try {
            reader = new CsvSpreadSheetReader();
            result[0] = reader.read((File)file);
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetToNumericTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        file = new TmpFile("date.csv");
        try {
            reader = new CsvSpreadSheetReader();
            reader.setDateColumns((Range)new SpreadSheetColumnRange("2"));
            reader.setDateFormat(new DateFormatString("d/M/yyyy"));
            result[1] = reader.read((File)file);
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetToNumericTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetToNumeric[] result = new SpreadSheetToNumeric[3];
        result[0] = new SpreadSheetToNumeric();
        result[1] = new SpreadSheetToNumeric();
        result[1].setReplaceMissingCells(true);
        result[1].setMissingValue(-1.0);
        result[2] = new SpreadSheetToNumeric();
        result[2].setUnhandled(-999.0);
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetToNumericTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetToNumericTest.runTest((Test)SpreadSheetToNumericTest.suite());
    }
}

