/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Index;
import adams.core.IndexTest;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.io.FileNotFoundException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetColumnIndexTest
extends IndexTest {
    protected SpreadSheet m_Sheet;

    public SpreadSheetColumnIndexTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/core/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        String filename = "simple.csv";
        this.m_TestHelper.copyResourceToTmp(filename);
        this.m_Sheet = new CsvSpreadSheetReader().read((File)new TmpFile(filename));
        if (this.m_Sheet == null) {
            throw new FileNotFoundException("Test file '" + filename + "' not found?");
        }
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("simple.csv");
        super.tearDown();
    }

    protected Index newIndex(String index, int max) {
        if (index == null) {
            return new SpreadSheetColumnIndex();
        }
        return new SpreadSheetColumnIndex(index, max);
    }

    public void testColumnNames() {
        SpreadSheetColumnIndex index = new SpreadSheetColumnIndex();
        index.setSpreadSheet(null);
        index.setIndex("blah");
        SpreadSheetColumnIndexTest.assertEquals((String)"should be invalid", (int)-1, (int)index.getIntIndex());
        SpreadSheetColumnIndexTest.assertEquals((String)"should be same", (String)"blah", (String)index.getIndex());
        index.setSpreadSheet(this.m_Sheet);
        index.setIndex("Field");
        SpreadSheetColumnIndexTest.assertEquals((String)"should be valid", (int)0, (int)index.getIntIndex());
        SpreadSheetColumnIndexTest.assertEquals((String)"should be same", (String)"Field", (String)index.getIndex());
        index.setSpreadSheet(this.m_Sheet);
        index.setIndex("\"Field\"");
        SpreadSheetColumnIndexTest.assertEquals((String)"should be valid", (int)0, (int)index.getIntIndex());
        SpreadSheetColumnIndexTest.assertEquals((String)"should be same", (String)"\"Field\"", (String)index.getIndex());
        index.setSpreadSheet(this.m_Sheet);
        index.setIndex("field");
        SpreadSheetColumnIndexTest.assertEquals((String)"should be invalid", (int)-1, (int)index.getIntIndex());
        SpreadSheetColumnIndexTest.assertEquals((String)"should be same", (String)"field", (String)index.getIndex());
        index.setSpreadSheet(this.m_Sheet);
        index.setIndex("\"field\"");
        SpreadSheetColumnIndexTest.assertEquals((String)"should be invalid", (int)-1, (int)index.getIntIndex());
        SpreadSheetColumnIndexTest.assertEquals((String)"should be same", (String)"\"field\"", (String)index.getIndex());
        index.setSpreadSheet(this.m_Sheet);
        index.setIndex("Value");
        SpreadSheetColumnIndexTest.assertEquals((String)"should be valid", (int)2, (int)index.getIntIndex());
        SpreadSheetColumnIndexTest.assertEquals((String)"should be same", (String)"Value", (String)index.getIndex());
        index.setSpreadSheet(this.m_Sheet);
        index.setIndex("\"Value\"");
        SpreadSheetColumnIndexTest.assertEquals((String)"should be valid", (int)2, (int)index.getIntIndex());
        SpreadSheetColumnIndexTest.assertEquals((String)"should be same", (String)"\"Value\"", (String)index.getIndex());
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetColumnIndexTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetColumnIndexTest.runTest((Test)SpreadSheetColumnIndexTest.suite());
    }
}

