/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.conversion.AnyToString;
import adams.data.conversion.Conversion;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.input.SpreadSheetReader;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SpreadSheetExtractArray;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.StringJoin;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetExtractArrayTest
extends AbstractFlowTest {
    public SpreadSheetExtractArrayTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetExtractArrayTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            FileSupplier filesupplier = new FileSupplier();
            AbstractArgumentOption argOption = (AbstractArgumentOption)filesupplier.getOptionManager().findByProperty("files");
            ArrayList<PlaceholderFile> files = new ArrayList<PlaceholderFile>();
            files.add((PlaceholderFile)argOption.valueOf("${TMP}/iris.csv"));
            filesupplier.setFiles(files.toArray(new PlaceholderFile[0]));
            actors.add(filesupplier);
            SpreadSheetFileReader spreadsheetfilereader = new SpreadSheetFileReader();
            CsvSpreadSheetReader csvspreadsheetreader = new CsvSpreadSheetReader();
            DenseDataRow densedatarow = new DenseDataRow();
            csvspreadsheetreader.setDataRowType((DataRow)densedatarow);
            DefaultSpreadSheet defaultspreadsheet = new DefaultSpreadSheet();
            csvspreadsheetreader.setSpreadSheetType((SpreadSheet)defaultspreadsheet);
            spreadsheetfilereader.setReader((SpreadSheetReader)csvspreadsheetreader);
            actors.add(spreadsheetfilereader);
            SpreadSheetExtractArray spreadsheetextractarray = new SpreadSheetExtractArray();
            spreadsheetextractarray.setOutputArray(true);
            argOption = (AbstractArgumentOption)spreadsheetextractarray.getOptionManager().findByProperty("type");
            spreadsheetextractarray.setType((SpreadSheetExtractArray.ExtractionType)argOption.valueOf("ROW"));
            argOption = (AbstractArgumentOption)spreadsheetextractarray.getOptionManager().findByProperty("index");
            spreadsheetextractarray.setIndex((Index)argOption.valueOf("10"));
            actors.add(spreadsheetextractarray);
            ArrayProcess arrayprocess = new ArrayProcess();
            ArrayList<Convert> actors2 = new ArrayList<Convert>();
            Convert convert = new Convert();
            AnyToString anytostring = new AnyToString();
            convert.setConversion((Conversion)anytostring);
            actors2.add(convert);
            arrayprocess.setActors(actors2.toArray(new Actor[0]));
            actors.add(arrayprocess);
            StringJoin stringjoin = new StringJoin();
            argOption = (AbstractArgumentOption)stringjoin.getOptionManager().findByProperty("glue");
            stringjoin.setGlue((String)argOption.valueOf(","));
            actors.add(stringjoin);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            actors.add(dumpfile);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            SpreadSheetExtractArrayTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetExtractArrayTest.runTest((Test)SpreadSheetExtractArrayTest.suite());
    }
}

