/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetTypeHandler;

public abstract class AbstractMatrixToSpreadSheet
extends AbstractConversion
implements SpreadSheetTypeHandler {
    private static final long serialVersionUID = -2047404866165517428L;
    protected DataRow m_DataRowType;
    protected SpreadSheet m_SpreadSheetType;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)new DenseDataRow());
        this.m_OptionManager.add("spreadsheet-type", "spreadSheetType", (Object)new DefaultSpreadSheet());
    }

    public void setDataRowType(DataRow value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRow getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    public void setSpreadSheetType(SpreadSheet value) {
        this.m_SpreadSheetType = value;
        this.reset();
    }

    public SpreadSheet getSpreadSheetType() {
        return this.m_SpreadSheetType;
    }

    public String spreadSheetTypeTipText() {
        return "The type of spreadsheet to use for the data.";
    }

    public Class generates() {
        if (this.m_SpreadSheetType != null) {
            return this.m_SpreadSheetType.getClass();
        }
        return SpreadSheet.class;
    }

    protected SpreadSheet newInstance() {
        SpreadSheet result = this.m_SpreadSheetType.newInstance();
        result.setDataRowClass(this.m_DataRowType.getClass());
        return result;
    }
}

