/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import gnu.trove.list.array.TIntArrayList;

public abstract class AbstractSpreadSheetToMatrix<T>
extends AbstractConversion {
    private static final long serialVersionUID = 487215942580922724L;
    protected SpreadSheetColumnRange m_Columns;
    protected Range m_Rows;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The range of rows to use.";
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to use.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    protected abstract boolean includeColumn(SpreadSheet var1, int var2);

    protected abstract T[][] newMatrix(int var1, int var2);

    protected int[] determineColumns(SpreadSheet sheet) {
        int[] cols;
        TIntArrayList result = new TIntArrayList();
        this.m_Columns.setData(sheet);
        for (int col : cols = this.m_Columns.getIntIndices()) {
            if (!this.includeColumn(sheet, col)) continue;
            result.add(col);
        }
        return result.toArray();
    }

    protected abstract T getValue(SpreadSheet var1, Row var2, int var3);

    protected Object doConvert() throws Exception {
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_Rows.setMax(sheet.getRowCount());
        int[] rows = this.m_Rows.getIntIndices();
        if (rows.length == 0) {
            throw new IllegalStateException("No rows selected!");
        }
        int[] cols = this.determineColumns(sheet);
        if (cols.length == 0) {
            throw new IllegalStateException("No columns selected!");
        }
        T[][] result = this.newMatrix(rows.length, cols.length);
        for (int n = 0; n < rows.length; ++n) {
            DataRow row = sheet.getRow(rows[n]);
            for (int i = 0; i < cols.length; ++i) {
                result[n][i] = this.getValue(sheet, (Row)row, cols[i]);
            }
        }
        return result;
    }
}

