/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SparseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class JsonToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = 5430116668955307166L;
    protected String m_Prefix;
    protected boolean m_LeftPad;

    public String globalInfo() {
        return "Turns a JSON object into a spreadsheet, essentially flattening it.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
        this.m_OptionManager.add("left-pad", "leftPad", (Object)false);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the generated columns.";
    }

    public void setLeftPad(boolean value) {
        this.m_LeftPad = value;
        this.reset();
    }

    public boolean getLeftPad() {
        return this.m_LeftPad;
    }

    public String leftPadTipText() {
        return "If enabled, the index in the arrays gets left-padded with zeroes.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix);
    }

    public Class accepts() {
        return JSONAware.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected void flatten(String path, JSONArray json, SpreadSheet sheet, Row header) {
        int digits = Integer.toString(json.size() - 1).length();
        for (int i = 0; i < json.size(); ++i) {
            Object obj = json.get(i);
            String newPath = "[" + (this.m_LeftPad ? Utils.padLeft((String)("" + i), (char)'0', (int)digits) : "" + i) + "]";
            newPath = path != null ? path + newPath : this.m_Prefix + newPath;
            if (obj instanceof JSONObject) {
                this.flatten(newPath, (JSONObject)obj, sheet, header);
                continue;
            }
            if (obj instanceof JSONArray) {
                this.flatten(newPath, (JSONArray)obj, sheet, header);
                continue;
            }
            if (!header.hasCell(newPath)) {
                header.addCell(newPath).setContent(newPath);
            }
            sheet.getRow(0).addCell(newPath).setNative(obj);
        }
    }

    protected void flatten(String path, JSONObject json, SpreadSheet sheet, Row header) {
        for (String key : json.keySet()) {
            Object obj = json.get((Object)key);
            String newPath = key;
            newPath = path != null ? path + "." + newPath : this.m_Prefix + newPath;
            if (obj instanceof JSONObject) {
                this.flatten(newPath, (JSONObject)obj, sheet, header);
                continue;
            }
            if (obj instanceof JSONArray) {
                this.flatten(newPath, (JSONArray)obj, sheet, header);
                continue;
            }
            if (!header.hasCell(newPath)) {
                header.addCell(newPath).setContent(newPath);
            }
            sheet.getRow(0).addCell(newPath).setNative(obj);
        }
    }

    protected Object doConvert() throws Exception {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        result.setDataRowClass(SparseDataRow.class);
        result.addRow();
        HeaderRow header = result.getHeaderRow();
        if (this.m_Input instanceof JSONObject) {
            this.flatten(null, (JSONObject)this.m_Input, (SpreadSheet)result, (Row)header);
        } else if (this.m_Input instanceof JSONArray) {
            this.flatten(null, (JSONArray)this.m_Input, (SpreadSheet)result, (Row)header);
        } else {
            throw new IllegalStateException("Cannot handle: " + this.m_Input.getClass().getName());
        }
        return result;
    }
}

