/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class PropertiesToSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = -766057153764739358L;

    public String globalInfo() {
        return "Turns a properties object into a spreadsheet with two columns, one for the key and one for the value.";
    }

    public Class accepts() {
        return Properties.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        Properties props = (Properties)this.m_Input;
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        ArrayList<String> sorted = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(sorted);
        for (String name : sorted) {
            row = result.addRow();
            row.addCell("K").setContentAsString(name);
            row.addCell("V").setContent(props.getProperty(name));
        }
        return result;
    }
}

