/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;

public class SpreadSheetAddSumColumn
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = 1320593539567099350L;
    protected String m_Header;
    protected Range m_Rows;

    public String globalInfo() {
        return "Adds a column with 'sum' formulas for the specified rows.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("header", "header", (Object)"Sum");
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
    }

    public void setHeader(String value) {
        this.m_Header = value;
        this.reset();
    }

    public String getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The title of the formula column.";
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The range of rows to add the 'sum' formula for.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        this.m_Rows.setMax(result.getRowCount());
        int[] rows = this.m_Rows.getIntIndices();
        result.insertColumn(result.getColumnCount(), this.m_Header);
        for (int i = 0; i < rows.length; ++i) {
            String from = SpreadSheetUtils.getCellPosition((int)rows[i], (int)0);
            String to = SpreadSheetUtils.getCellPosition((int)rows[i], (int)(result.getColumnCount() - 2));
            DataRow row = result.getRow(rows[i]);
            row.addCell(result.getColumnCount() - 1).setContent("=SUM(" + from + ":" + to + ")");
        }
        return result;
    }
}

