/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class SpreadSheetBinarize
extends AbstractSpreadSheetConversion {
    private static final long serialVersionUID = -5364554292793461868L;
    public static final String SEPARATOR = "-";
    protected SpreadSheetColumnRange m_Columns;
    protected BinarizeType m_BinarizeType;
    protected String m_LabelPositive;
    protected String m_LabelNegative;

    public String globalInfo() {
        return "Binarizes the non-numeric columns in the selected column range by creating a new column for each of the labels.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("binarize-type", "binarizeType", (Object)BinarizeType.NUMERIC);
        this.m_OptionManager.add("label-positive", "labelPositive", (Object)"yes");
        this.m_OptionManager.add("label-negative", "labelNegative", (Object)"no");
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to binarize.";
    }

    public void setBinarizeType(BinarizeType value) {
        this.m_BinarizeType = value;
        this.reset();
    }

    public BinarizeType getBinarizeType() {
        return this.m_BinarizeType;
    }

    public String binarizeTypeTipText() {
        return "The type of binarization to perform.";
    }

    public void setLabelPositive(String value) {
        this.m_LabelPositive = value;
        this.reset();
    }

    public String getLabelPositive() {
        return this.m_LabelPositive;
    }

    public String labelPositiveTipText() {
        return "The positive label (ie 1s) in case of " + (Object)((Object)BinarizeType.LABELS) + ".";
    }

    public void setLabelNegative(String value) {
        this.m_LabelNegative = value;
        this.reset();
    }

    public String getLabelNegative() {
        return this.m_LabelNegative;
    }

    public String labelNegativeTipText() {
        return "The negative label (ie 0s) in case of " + (Object)((Object)BinarizeType.LABELS) + ".";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)((Object)this.m_Columns), (String)"cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"binarizeType", (Object)((Object)this.m_BinarizeType), (String)", type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labelPositive", (Object)this.m_LabelPositive, (String)", pos: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labelNegative", (Object)this.m_LabelNegative, (String)", neg: ");
        return result;
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        int n;
        ArrayList labels;
        int i;
        this.m_Columns.setSpreadSheet(input);
        int[] indices = this.m_Columns.getIntIndices();
        if (indices.length == 0) {
            return input;
        }
        HashMap mapping = new HashMap();
        for (i = 0; i < indices.length; ++i) {
            if (input.isNumeric(indices[i], true)) continue;
            labels = input.getCellValues(indices[i]);
            if (!mapping.containsKey(indices[i])) {
                mapping.put(indices[i], new ArrayList());
            }
            for (n = 0; n < labels.size(); ++n) {
                ((List)mapping.get(indices[i])).add(labels.get(n));
            }
        }
        SpreadSheet result = input.newInstance();
        result.setDataRowClass(input.getDataRowClass());
        result.addComment(input.getComments());
        result.setName(input.getName());
        HeaderRow rowRes = result.getHeaderRow();
        HeaderRow rowInp = input.getHeaderRow();
        for (i = 0; i < input.getColumnCount(); ++i) {
            if (this.m_Columns.isInRange(i) && mapping.containsKey(i)) {
                labels = new ArrayList((Collection)mapping.get(i));
                for (String label : labels) {
                    String binarized = rowInp.getCell(i).getContent() + SEPARATOR + label;
                    rowRes.addCell("" + rowRes.getCellCount()).setContent(binarized);
                }
                continue;
            }
            rowRes.addCell("" + rowRes.getCellCount()).assign(rowInp.getCell(i));
        }
        for (Row row : input.rows()) {
            rowRes = result.addRow();
            n = 0;
            for (i = 0; i < input.getColumnCount(); ++i) {
                if (!row.hasCell(i) || row.getCell(i).isMissing()) {
                    rowRes.addCell(n).setMissing();
                    ++n;
                    continue;
                }
                if (this.m_Columns.isInRange(i) && mapping.containsKey(i)) {
                    labels = new ArrayList((Collection)mapping.get(i));
                    for (String label : labels) {
                        boolean match = label.equals(row.getCell(i).getContent());
                        switch (this.m_BinarizeType) {
                            case NUMERIC: {
                                rowRes.addCell(n).setContent(Integer.valueOf(match ? 1 : 0));
                                break;
                            }
                            case BOOLEAN: {
                                rowRes.addCell(n).setContent(Boolean.valueOf(match));
                                break;
                            }
                            case LABELS: {
                                rowRes.addCell(n).setContent(match ? this.m_LabelPositive : this.m_LabelNegative);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled binarize type: " + (Object)((Object)this.m_BinarizeType));
                            }
                        }
                        ++n;
                    }
                    continue;
                }
                rowRes.addCell(n).assign(row.getCell(i));
                ++n;
            }
        }
        return result;
    }

    public static enum BinarizeType {
        NUMERIC,
        BOOLEAN,
        LABELS;

    }
}

