/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.conversion.AbstractConversion;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import java.io.StringWriter;
import java.io.Writer;

public class SpreadSheetToString
extends AbstractConversion {
    private static final long serialVersionUID = 4890225060389916155L;
    protected SpreadSheetWriter m_Writer;
    protected SpreadSheetWriter m_ActualWriter;

    public String globalInfo() {
        return "Turns a spreadsheet into a string using the specified spreadsheet writer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", (Object)new CsvSpreadSheetWriter());
    }

    protected void reset() {
        super.reset();
        this.m_ActualWriter = null;
    }

    public void setWriter(SpreadSheetWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer setup to use for generating the string.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return String.class;
    }

    protected Object doConvert() throws Exception {
        StringWriter writer = new StringWriter();
        if (this.m_ActualWriter == null) {
            this.m_ActualWriter = (SpreadSheetWriter)OptionUtils.shallowCopy((OptionHandler)this.m_Writer, (boolean)true);
        }
        this.m_ActualWriter.write((SpreadSheet)this.m_Input, (Writer)writer);
        return writer.toString();
    }
}

