/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featureconverter;

import adams.data.featureconverter.AbstractFeatureConverter;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheetTypeHandler;
import java.util.List;

public class SpreadSheet
extends AbstractFeatureConverter<adams.data.spreadsheet.SpreadSheet, Row>
implements SpreadSheetTypeHandler {
    private static final long serialVersionUID = -1696817128027564877L;
    protected DataRow m_DataRowType;
    protected adams.data.spreadsheet.SpreadSheet m_SpreadSheetType;

    public String globalInfo() {
        return "Turns the features into spreadsheet format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)this.getDefaultDataRowType());
        this.m_OptionManager.add("spreadsheet-type", "spreadSheetType", (Object)this.getDefaultSpreadSheetType());
    }

    protected DataRow getDefaultDataRowType() {
        return new DenseDataRow();
    }

    public void setDataRowType(DataRow value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRow getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    protected adams.data.spreadsheet.SpreadSheet getDefaultSpreadSheetType() {
        return new DefaultSpreadSheet();
    }

    public void setSpreadSheetType(adams.data.spreadsheet.SpreadSheet value) {
        this.m_SpreadSheetType = value;
        this.reset();
    }

    public adams.data.spreadsheet.SpreadSheet getSpreadSheetType() {
        return this.m_SpreadSheetType;
    }

    public String spreadSheetTypeTipText() {
        return "The type of spreadsheet to use for the data.";
    }

    public Class getDatasetFormat() {
        return this.m_SpreadSheetType.getClass();
    }

    public Class getRowFormat() {
        return Row.class;
    }

    protected adams.data.spreadsheet.SpreadSheet doGenerateHeader(HeaderDefinition header) {
        adams.data.spreadsheet.SpreadSheet result = this.m_SpreadSheetType.getClone();
        result.setDataRowClass(this.m_DataRowType.getClass());
        result.setName(header.getDataset());
        HeaderRow row = result.getHeaderRow();
        for (String name : header.getNames()) {
            row.addCell("" + row.getCellCount()).setContent(name);
        }
        return result;
    }

    protected Row doGenerateRow(List<Object> data) {
        adams.data.spreadsheet.SpreadSheet sheet = ((adams.data.spreadsheet.SpreadSheet)this.m_Header).getClone();
        DataRow result = sheet.addRow();
        block5: for (int i = 0; i < data.size(); ++i) {
            Object obj = data.get(i);
            Cell cell = result.addCell(i);
            if (obj == null) {
                cell.setMissing();
                continue;
            }
            switch (this.m_HeaderDefinition.getType(i)) {
                case BOOLEAN: {
                    cell.setContent((Boolean)obj);
                    continue block5;
                }
                case NUMERIC: {
                    if (obj instanceof Integer) {
                        cell.setContent((Integer)obj);
                        continue block5;
                    }
                    if (obj instanceof Long) {
                        cell.setContent((Long)obj);
                        continue block5;
                    }
                    cell.setContent(Double.valueOf(((Number)obj).doubleValue()));
                    continue block5;
                }
                case STRING: 
                case UNKNOWN: {
                    cell.setContentAsString(obj.toString());
                }
            }
        }
        return result;
    }
}

