/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.data.spreadsheet.cellfinder.CellLocation;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeIterator
implements Iterator<CellLocation> {
    protected int[] m_Rows;
    protected int[] m_Columns;
    protected int m_Row;
    protected int m_Column;

    public RangeIterator(int[] rows, int[] cols) {
        this.m_Rows = (int[])rows.clone();
        this.m_Columns = (int[])cols.clone();
        this.m_Row = -1;
        this.m_Column = this.m_Columns.length - 1;
    }

    @Override
    public boolean hasNext() {
        return this.m_Row != this.m_Rows.length - 1 || this.m_Column != this.m_Columns.length - 1;
    }

    @Override
    public CellLocation next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.m_Column;
        if (this.m_Column == this.m_Columns.length) {
            ++this.m_Row;
            this.m_Column = 0;
        }
        return new CellLocation(this.m_Rows[this.m_Row], this.m_Columns[this.m_Column]);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

