/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractColumnFinder;
import gnu.trove.list.array.TIntArrayList;

public class DownSample
extends AbstractColumnFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected int m_NthColumn;

    public String globalInfo() {
        return "Returns the indices of every n-th column.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("nth", "nthColumn", (Object)1);
    }

    public void setNthColumn(int value) {
        this.m_NthColumn = value;
        this.reset();
    }

    public int getNthColumn() {
        return this.m_NthColumn;
    }

    public String nthColumnTipText() {
        return "Only every n-th column will be output.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"nthColumn", (Object)this.m_NthColumn, (String)"nth: ");
    }

    @Override
    protected int[] doFindColumns(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < data.getColumnCount(); i += this.m_NthColumn) {
            result.add(i);
        }
        return result.toArray();
    }
}

