/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.matrixstatistic;

import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.matrixstatistic.AbstractMatrixStatistic;

public class MultiMatrixStatistic
extends AbstractMatrixStatistic {
    private static final long serialVersionUID = 2141252366056112668L;
    protected AbstractMatrixStatistic[] m_Statistics;

    public String globalInfo() {
        return "Combines the statistics calculated from the specified statistic generators.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistics", (Object)new AbstractMatrixStatistic[0]);
    }

    public void setStatistics(AbstractMatrixStatistic[] value) {
        this.m_Statistics = value;
        this.reset();
    }

    public AbstractMatrixStatistic[] getStatistics() {
        return this.m_Statistics;
    }

    public String statisticsTipText() {
        return "The statistics to calculate.";
    }

    @Override
    protected SpreadSheet doGenerate(SpreadSheet sheet) {
        SpreadSheet result = this.createOutputHeader();
        for (int i = 0; i < this.m_Statistics.length; ++i) {
            AbstractMatrixStatistic stat = this.m_Statistics[i];
            SpreadSheet sub = stat.generate(sheet);
            if (stat.hasLastError()) {
                this.m_LastError = !this.hasLastError() ? "#" + (i + 1) + ": " + stat.getLastError() : this.m_LastError + "\n#" + (i + 1) + ": " + stat.getLastError();
            }
            if (sub == null || stat.hasLastError()) continue;
            for (Row row : sub.rows()) {
                result.addRow().assign(row);
            }
        }
        return result;
    }
}

