/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import gnu.trove.list.array.TIntArrayList;

public class ClosestNumericValue
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    protected SpreadSheetColumnIndex m_AttributeIndex;
    protected double m_Value;
    protected SearchDirection m_SearchDirection;

    public String globalInfo() {
        return "Returns the index of the row that comes closest to the provided numeric value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("value", "value", (Object)0.0);
        this.m_OptionManager.add("search-direction", "searchDirection", (Object)SearchDirection.ANY);
    }

    public void setAttributeIndex(SpreadSheetColumnIndex value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setValue(double value) {
        this.m_Value = value;
        this.reset();
    }

    public double getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to get to as close as possible.";
    }

    public void setSearchDirection(SearchDirection value) {
        this.m_SearchDirection = value;
        this.reset();
    }

    public SearchDirection getSearchDirection() {
        return this.m_SearchDirection;
    }

    public String searchDirectionTipText() {
        return "Determines how the search is performed: whether the closest value has to be below or above the specified value or doesn't matter.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"attributeIndex", (Object)((Object)this.m_AttributeIndex), (String)"col: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)", value: ");
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int[] doFindRows(SpreadSheet data) {
        TIntArrayList result = new TIntArrayList();
        this.m_AttributeIndex.setSpreadSheet(data);
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        if (!data.isNumeric(index, true)) {
            throw new IllegalStateException("Column at index '" + this.m_AttributeIndex.getIndex() + "' is not numeric!");
        }
        double diff = Double.POSITIVE_INFINITY;
        int rowIndex = -1;
        block4: for (int i = 0; i < data.getRowCount(); ++i) {
            Cell cell;
            DataRow row = data.getRow(i);
            if (!row.hasCell(index) || (cell = row.getCell(index)).isMissing() || !cell.isNumeric()) continue;
            double value = cell.toDouble();
            switch (this.m_SearchDirection) {
                case FROM_ABOVE: {
                    if (!(value < this.m_Value)) break;
                    continue block4;
                }
                case FROM_BELOW: {
                    if (value > this.m_Value) continue block4;
                }
            }
            double diffNew = Math.abs(value - this.m_Value);
            if (!(diffNew < diff)) continue;
            rowIndex = i;
            diff = diffNew;
        }
        if (rowIndex > -1) {
            result.add(rowIndex);
            if (!this.isLoggingEnabled()) return result.toArray();
            this.getLogger().info("Closest row (0-based) to " + this.m_Value + ": " + rowIndex + " (diff: " + diff + ")");
            return result.toArray();
        }
        this.getLogger().warning("No closest row found for value " + this.m_Value + "!");
        return result.toArray();
    }

    public static enum SearchDirection {
        ANY,
        FROM_BELOW,
        FROM_ABOVE;

    }
}

