/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowstatistic;

import adams.core.ErrorProvider;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;

public abstract class AbstractRowStatistic
extends AbstractOptionHandler
implements ErrorProvider {
    private static final long serialVersionUID = -7187115330070305271L;
    protected String m_LastError;

    public boolean hasLastError() {
        return this.m_LastError != null;
    }

    public String getLastError() {
        return this.m_LastError;
    }

    protected String check(SpreadSheet sheet, int rowIndex) {
        String result = null;
        if (sheet == null) {
            result = "No data provided!";
        }
        if (result == null && rowIndex >= sheet.getRowCount()) {
            result = "Row index out of bounds: " + rowIndex;
        }
        return result;
    }

    protected SpreadSheet createOutputHeader() {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("K").setContent("Key");
        row.addCell("V").setContent("Value");
        return result;
    }

    protected abstract void preVisit(SpreadSheet var1, int var2);

    protected abstract void doVisit(Row var1, int var2);

    protected abstract SpreadSheet postVisit(SpreadSheet var1, int var2);

    protected SpreadSheet doGenerate(SpreadSheet sheet, int rowIndex) {
        this.preVisit(sheet, rowIndex);
        DataRow row = sheet.getRow(rowIndex);
        for (int i = 0; i < sheet.getColumnCount(); ++i) {
            this.doVisit((Row)row, i);
        }
        return this.postVisit(sheet, rowIndex);
    }

    public SpreadSheet generate(SpreadSheet sheet, int rowIndex) {
        SpreadSheet result = null;
        this.m_LastError = this.check(sheet, rowIndex);
        if (this.m_LastError == null && (result = this.doGenerate(sheet, rowIndex)) == null && this.m_LastError == null) {
            this.m_LastError = "Error occurred generating statistics!";
        }
        return result;
    }
}

