/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowstatistic;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowstatistic.AbstractRowStatistic;
import gnu.trove.set.hash.TDoubleHashSet;
import java.util.HashSet;

public class Distinct
extends AbstractRowStatistic {
    private static final long serialVersionUID = 4899075284716702404L;
    protected TDoubleHashSet m_Numbers;
    protected HashSet<String> m_Labels;

    public String globalInfo() {
        return "Counts the distinct numeric/string values.";
    }

    @Override
    protected void preVisit(SpreadSheet sheet, int rowIndex) {
        this.m_Numbers = new TDoubleHashSet();
        this.m_Labels = new HashSet();
    }

    @Override
    protected void doVisit(Row row, int colIndex) {
        if (row.hasCell(colIndex)) {
            Cell cell = row.getCell(colIndex);
            if (cell.isNumeric()) {
                this.m_Numbers.add(cell.toDouble().doubleValue());
            } else if (!cell.isMissing()) {
                this.m_Labels.add(cell.getContent());
            }
        }
    }

    @Override
    protected SpreadSheet postVisit(SpreadSheet sheet, int rowIndex) {
        DataRow row;
        SpreadSheet result = this.createOutputHeader();
        if (this.m_Numbers.size() > 0) {
            row = result.addRow();
            row.addCell(0).setContent("Distinct numbers");
            row.addCell(1).setContent(Integer.valueOf(this.m_Numbers.size()));
        }
        if (this.m_Labels.size() > 0) {
            row = result.addRow();
            row.addCell(0).setContent("Distinct labels");
            row.addCell(1).setContent(Integer.valueOf(this.m_Labels.size()));
        }
        this.m_Numbers = null;
        this.m_Labels = null;
        return result;
    }
}

