/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.sql;

import adams.core.Stoppable;
import adams.core.Utils;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.core.logging.LoggingSupporter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.ColumnNameConversion;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.db.SQL;
import java.sql.BatchUpdateException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

public class Writer
extends LoggingObject
implements Stoppable {
    private static final long serialVersionUID = 1094278005436201843L;
    public static final String PLACEHOLDER_MAX = "@MAX";
    protected AbstractTypeMapper m_TypeMapper;
    protected SpreadSheet m_Sheet;
    protected String m_Table;
    protected Cell.ContentType[] m_ContentTypes;
    protected int m_MaxColumnLength;
    protected String[] m_ColumnNames;
    protected ColumnNameConversion m_ColumnNameConversion;
    protected String m_StringColumnSQL;
    protected int m_MaxStringLength;
    protected int m_BatchSize;
    protected boolean m_Stopped;

    public Writer(SpreadSheet sheet, AbstractTypeMapper typeMapper, String table, int maxCol, ColumnNameConversion colName, String stringCol, int maxStr, int batchSize) {
        this.m_Sheet = sheet;
        this.m_TypeMapper = typeMapper;
        this.m_Table = table;
        this.m_MaxColumnLength = maxCol;
        this.m_ColumnNameConversion = colName;
        this.m_StringColumnSQL = stringCol;
        this.m_MaxStringLength = maxStr;
        this.m_BatchSize = batchSize;
        this.generate();
    }

    protected void generate() {
        int i;
        this.m_ContentTypes = new Cell.ContentType[this.m_Sheet.getColumnCount()];
        for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
            this.m_ContentTypes[i] = Cell.ContentType.STRING;
            if (this.m_Sheet.isNumeric(i)) {
                this.m_ContentTypes[i] = Cell.ContentType.DOUBLE;
                Collection types = this.m_Sheet.getContentTypes(i);
                if (types.size() != 1 || !types.contains(Cell.ContentType.LONG)) continue;
                this.m_ContentTypes[i] = Cell.ContentType.LONG;
                continue;
            }
            Cell.ContentType type = this.m_Sheet.getContentType(i);
            if (type == null) {
                type = Cell.ContentType.STRING;
            }
            switch (type) {
                case TIME: 
                case TIMEMSEC: 
                case DATE: 
                case DATETIME: 
                case DATETIMEMSEC: {
                    this.m_ContentTypes[i] = type;
                }
            }
        }
        this.m_ColumnNames = new String[this.m_Sheet.getColumnCount()];
        HashSet<String> names = new HashSet<String>();
        for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
            String name = this.m_Sheet.getHeaderRow().getCell(i).getContent();
            String prefix = name = this.fixColumnName(name);
            int count = 0;
            while (names.contains(name)) {
                if ((prefix + ++count).length() > this.m_MaxColumnLength) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                name = prefix + count;
            }
            names.add(name);
            this.m_ColumnNames[i] = name;
        }
    }

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
    }

    public AbstractTypeMapper getTypeMapper() {
        return this.m_TypeMapper;
    }

    public String getTable() {
        return this.m_Table;
    }

    public ColumnNameConversion getColumnNameConversion() {
        return this.m_ColumnNameConversion;
    }

    public int getMaxStringLength() {
        return this.m_MaxStringLength;
    }

    public String getStringColumnSQL() {
        return this.m_StringColumnSQL;
    }

    protected String fixColumnName(String s) {
        String result = "";
        for (int i = 0; i < s.length(); ++i) {
            char chr = s.charAt(i);
            if (chr >= 'A' && chr <= 'Z') {
                result = result + chr;
            } else if (chr >= 'a' && chr <= 'z') {
                result = result + chr;
            }
            if (i < 0) continue;
            if (chr >= '0' && chr <= '9') {
                result = result + chr;
                continue;
            }
            if (chr != '_') continue;
            result = result + chr;
        }
        if (result.length() > this.m_MaxColumnLength) {
            result = result.substring(0, this.m_MaxColumnLength);
        }
        switch (this.m_ColumnNameConversion) {
            case AS_IS: {
                break;
            }
            case LOWER_CASE: {
                result = result.toLowerCase();
                break;
            }
            case UPPER_CASE: {
                result = result.toUpperCase();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled conversion type: " + (Object)((Object)this.m_ColumnNameConversion));
            }
        }
        return result;
    }

    public String getCreateStatement() {
        String stringType = this.m_StringColumnSQL.replace(PLACEHOLDER_MAX, "" + this.m_MaxStringLength);
        StringBuilder result = new StringBuilder("CREATE TABLE " + this.m_Table + "(");
        for (int i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.m_ColumnNames[i]);
            result.append(" ");
            result.append(this.m_TypeMapper.contentTypeToSqlCreateType(this.m_ContentTypes[i], stringType));
        }
        result.append(");");
        return result.toString();
    }

    public String getInsertStatement() {
        int i;
        StringBuilder result = new StringBuilder("INSERT INTO " + this.m_Table + "(");
        for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.m_ColumnNames[i]);
        }
        result.append(") VALUES (");
        for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append("?");
        }
        result.append(");");
        return result.toString();
    }

    public String[] getColumnNames() {
        return this.m_ColumnNames;
    }

    public Cell.ContentType[] getContentTypes() {
        return this.m_ContentTypes;
    }

    public String createTable(SQL sql) {
        String result = null;
        String query = this.getCreateStatement();
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Query: " + query);
        }
        try {
            Boolean rs = sql.execute(query);
            if (rs == null) {
                result = "Failed to create table, check console!";
            }
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingSupporter)this, (String)("Failed to create table '" + this.m_Table + "' using: " + query), (Throwable)e);
        }
        return result;
    }

    public String writeData(SQL sql) {
        PreparedStatement stmt;
        int i;
        String result = null;
        StringBuilder query = new StringBuilder("INSERT INTO " + this.m_Table + "(");
        for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
            if (i > 0) {
                query.append(", ");
            }
            query.append(this.m_ColumnNames[i]);
        }
        query.append(") VALUES (");
        for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
            if (i > 0) {
                query.append(", ");
            }
            query.append("?");
        }
        query.append(");");
        try {
            stmt = sql.prepareStatement(query.toString());
        }
        catch (Exception e) {
            result = Utils.handleException((LoggingSupporter)this, (String)("Failed to prepare statement: " + query), (Throwable)e);
            stmt = null;
        }
        if (result == null && stmt != null) {
            int count;
            this.m_Stopped = false;
            int lastInsert = count = 0;
            for (Row row : this.m_Sheet.rows()) {
                if (this.m_Stopped) break;
                ++count;
                try {
                    block16: for (i = 0; i < this.m_Sheet.getColumnCount(); ++i) {
                        Cell cell = row.getCell(i);
                        if (cell == null || cell.isMissing()) {
                            int type = this.m_TypeMapper.contentTypeToSqlType(this.m_ContentTypes[i]);
                            stmt.setNull(i + 1, type);
                            continue;
                        }
                        switch (this.m_ContentTypes[i]) {
                            case DATE: {
                                stmt.setDate(i + 1, new Date(cell.toAnyDateType().getTime()));
                                continue block16;
                            }
                            case DATETIME: 
                            case DATETIMEMSEC: {
                                stmt.setTimestamp(i + 1, new Timestamp(cell.toAnyDateType().getTime()));
                                continue block16;
                            }
                            case TIME: 
                            case TIMEMSEC: {
                                stmt.setTime(i + 1, new Time(cell.toAnyDateType().getTime()));
                                continue block16;
                            }
                            case DOUBLE: {
                                stmt.setDouble(i + 1, cell.toDouble());
                                continue block16;
                            }
                            case LONG: {
                                stmt.setInt(i + 1, cell.toLong().intValue());
                                continue block16;
                            }
                            case BOOLEAN: {
                                stmt.setBoolean(i + 1, cell.toBoolean());
                                continue block16;
                            }
                            default: {
                                String str = cell.getContent();
                                if (str.length() > this.m_MaxStringLength) {
                                    str = str.substring(0, this.m_MaxStringLength);
                                }
                                stmt.setString(i + 1, str);
                            }
                        }
                    }
                    if (this.m_BatchSize > 1) {
                        stmt.addBatch();
                        if (count % this.m_BatchSize == 0 || count == this.m_Sheet.getRowCount()) {
                            stmt.executeBatch();
                            lastInsert = count;
                        }
                    } else {
                        stmt.execute();
                        lastInsert = count;
                    }
                }
                catch (BatchUpdateException e) {
                    result = Utils.handleException((LoggingSupporter)this, (String)("Failed to insert batch (last successful batch insert at row " + lastInsert + ")!"), (Throwable)e) + Utils.handleException((LoggingSupporter)this, (String)"Next exception:", (Throwable)e.getNextException());
                    break;
                }
                catch (Exception e) {
                    if (this.m_BatchSize == 1) {
                        result = Utils.handleException((LoggingSupporter)this, (String)("Failed to insert data: " + row + "\nusing: " + stmt), (Throwable)e);
                        break;
                    }
                    result = Utils.handleException((LoggingSupporter)this, (String)("Failed to insert batch (last successful batch insert at row " + lastInsert + ")!"), (Throwable)e);
                    break;
                }
                if (count % 1000 != 0) continue;
                this.getLogger().info(count + " rows processed");
                System.out.println(count + " rows processed");
            }
        }
        SQL.close((Statement)stmt);
        return result;
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }
}

