/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.JAIImageWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.sink.AbstractFileWriter;
import adams.gui.visualization.jfreechart.chart.AbstractChartGenerator;
import adams.gui.visualization.jfreechart.chart.XYLineChart;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import java.awt.image.BufferedImage;
import org.jfree.chart.JFreeChart;

public class JFreeChartFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = -2648121220428217287L;
    protected AbstractDatasetGenerator m_Dataset;
    protected AbstractChartGenerator m_Chart;
    protected int m_Width;
    protected int m_Height;
    protected AbstractImageWriter m_Writer;

    public String globalInfo() {
        return "Generates a JFreeChart plot and writes the bitmap to a file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dataset", "dataset", (Object)new DefaultXY());
        this.m_OptionManager.add("chart", "chart", (Object)new XYLineChart());
        this.m_OptionManager.add("width", "width", (Object)800, (Number)-1, null);
        this.m_OptionManager.add("height", "height", (Object)600, (Number)-1, null);
        this.m_OptionManager.add("writer", "writer", (Object)new JAIImageWriter());
    }

    public String outputFileTipText() {
        return "The file to write the plot to";
    }

    public void setDataset(AbstractDatasetGenerator value) {
        this.m_Dataset = value;
        this.reset();
    }

    public AbstractDatasetGenerator getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset generator to use.";
    }

    public void setChart(AbstractChartGenerator value) {
        this.m_Chart = value;
        this.reset();
    }

    public AbstractChartGenerator getChart() {
        return this.m_Chart;
    }

    public String chartTipText() {
        return "The chart generator to use.";
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the plot.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the plot.";
    }

    public void setWriter(AbstractImageWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractImageWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The image writer to use.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataset", (Object)((Object)this.m_Dataset), (String)", dataset: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"chart", (Object)((Object)this.m_Chart), (String)", chart: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)", width:");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", height:");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"writer", (Object)this.m_Writer, (String)", writer: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            Object dataset = this.m_Dataset.generate(sheet);
            JFreeChart jfreechart = this.m_Chart.generate(dataset);
            BufferedImage image = jfreechart.createBufferedImage(this.m_Width, this.m_Height);
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage((Object)image);
            this.m_Writer.write(this.m_OutputFile, (AbstractImageContainer)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate plot!", e);
        }
        return result;
    }
}

