/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Reader;
import adams.db.AbstractDatabaseConnection;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleDbSource;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.logging.Level;

public abstract class AbstractDatabaseMetaData
extends AbstractSimpleDbSource {
    private static final long serialVersionUID = -8462709950859959951L;
    public static String[] JDBC_VALUES = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "autoCommitFailureClosesAllResultSets", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "generatedKeyAlwaysReturned", "getCatalogSeparator", "getCatalogTerm", "getDatabaseMajorVersion", "getDatabaseMinorVersion", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getJDBCMajorVersion", "getJDBCMinorVersion", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxLogicalLobSize", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getResultSetHoldability", "getRowIdLifetime", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getSQLStateType", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "locatorsUpdateCopy", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGetGeneratedKeys", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleOpenResults", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNamedParameters", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsRefCursors", "supportsSavepoints", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStatementPooling", "supportsStoredFunctionsUsingCallSyntax", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};
    protected AbstractTypeMapper m_TypeMapper;
    protected MetaDataType m_MetaDataType;
    protected String m_Table;

    public String globalInfo() {
        return "Outputs the meta-data of the current database connection.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type-mapper", "typeMapper", (Object)new DefaultTypeMapper());
        this.m_OptionManager.add("meta-data-type", "metaDataType", (Object)MetaDataType.BASIC);
        this.m_OptionManager.add("table", "table", (Object)"");
    }

    public void setTypeMapper(AbstractTypeMapper value) {
        this.m_TypeMapper = value;
        this.reset();
    }

    public AbstractTypeMapper getTypeMapper() {
        return this.m_TypeMapper;
    }

    public String typeMapperTipText() {
        return "The type mapper to use for mapping spreadsheet and SQL types.";
    }

    public void setMetaDataType(MetaDataType value) {
        this.m_MetaDataType = value;
        this.reset();
    }

    public MetaDataType getMetaDataType() {
        return this.m_MetaDataType;
    }

    public String metaDataTypeTipText() {
        return "The type of meta-data to retrieve.";
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        MetaDataType[] types = new MetaDataType[]{MetaDataType.COLUMN_PRIVILEGES, MetaDataType.EXPORTED_KEYS, MetaDataType.IMPORTED_KEYS, MetaDataType.INDEX_INFO, MetaDataType.PRIMARY_KEYS, MetaDataType.VERSION_COLUMNS};
        return "The table to retrieve the information for (" + Utils.flatten((Object[])types, (String)", ") + ").";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataType", (Object)((Object)this.m_MetaDataType), (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"table", (Object)(this.m_Table.isEmpty() ? "-none-" : this.m_Table), (String)", table: ");
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected abstract AbstractDatabaseConnection getDatabaseConnection();

    protected void addRow(SpreadSheet sheet, String key, Object value) {
        DataRow row = sheet.addRow();
        row.addCell("K").setContentAsString(key);
        row.addCell("V").setNative(value);
    }

    protected void addRow(DatabaseMetaData metadata, SpreadSheet sheet, String key) {
        try {
            Method method = metadata.getClass().getMethod(key, new Class[0]);
            if (key.startsWith("get")) {
                key = key.substring(3);
            }
            key = key.substring(0, 1).toUpperCase() + key.substring(1);
            this.addRow(sheet, key, method.invoke((Object)metadata, new Object[0]));
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to retrieve value for: " + key, (Throwable)e);
        }
    }

    protected String queryDatabase() {
        String result = null;
        ResultSet rs = null;
        DefaultSpreadSheet sheet = null;
        try {
            DatabaseMetaData metadata = this.m_DatabaseConnection.getConnection(false).getMetaData();
            Reader reader = new Reader(this.m_TypeMapper, DenseDataRow.class);
            switch (this.m_MetaDataType) {
                case CONNECTION: {
                    sheet = new DefaultSpreadSheet();
                    HeaderRow row = sheet.getHeaderRow();
                    row.addCell("K").setContentAsString("Key");
                    row.addCell("V").setContentAsString("Value");
                    String db = this.m_DatabaseConnection.getURL().replaceAll(".*\\/", "");
                    if (db.contains("?")) {
                        db = db.substring(0, db.indexOf("?"));
                    }
                    this.addRow((SpreadSheet)sheet, "URL", (Object)this.m_DatabaseConnection.getURL());
                    this.addRow((SpreadSheet)sheet, "Database", (Object)db);
                    this.addRow((SpreadSheet)sheet, "User", (Object)this.m_DatabaseConnection.getUser());
                    this.addRow((SpreadSheet)sheet, "Password", (Object)this.m_DatabaseConnection.getPassword().getValue());
                    break;
                }
                case BASIC: {
                    sheet = new DefaultSpreadSheet();
                    HeaderRow row = sheet.getHeaderRow();
                    row.addCell("K").setContentAsString("Key");
                    row.addCell("V").setContentAsString("Value");
                    for (String value : JDBC_VALUES) {
                        this.addRow(metadata, (SpreadSheet)sheet, value);
                    }
                    break;
                }
                case ATTRIBUTES: {
                    rs = metadata.getAttributes(null, null, "%", null);
                    sheet = reader.read(rs);
                    break;
                }
                case CATALOGS: {
                    rs = metadata.getCatalogs();
                    sheet = reader.read(rs);
                    break;
                }
                case CLIENT_INFO_PROPERTIES: {
                    rs = metadata.getClientInfoProperties();
                    sheet = reader.read(rs);
                    break;
                }
                case COLUMN_PRIVILEGES: {
                    rs = metadata.getColumnPrivileges(null, null, this.m_Table, "%");
                    sheet = reader.read(rs);
                    break;
                }
                case COLUMNS: {
                    rs = metadata.getColumns(null, null, "%", "%");
                    sheet = reader.read(rs);
                    break;
                }
                case EXPORTED_KEYS: {
                    rs = metadata.getExportedKeys(null, null, this.m_Table);
                    sheet = reader.read(rs);
                    break;
                }
                case FUNCTION_COLUMNS: {
                    rs = metadata.getFunctionColumns(null, null, "%", "%");
                    sheet = reader.read(rs);
                    break;
                }
                case FUNCTIONS: {
                    rs = metadata.getFunctions(null, null, "%");
                    sheet = reader.read(rs);
                    break;
                }
                case IMPORTED_KEYS: {
                    rs = metadata.getImportedKeys(null, null, this.m_Table);
                    sheet = reader.read(rs);
                    break;
                }
                case INDEX_INFO: {
                    rs = metadata.getIndexInfo(null, null, this.m_Table, false, false);
                    sheet = reader.read(rs);
                    break;
                }
                case PRIMARY_KEYS: {
                    rs = metadata.getPrimaryKeys(null, null, this.m_Table);
                    sheet = reader.read(rs);
                    break;
                }
                case PROCEDURE_COLUMNS: {
                    rs = metadata.getProcedureColumns(null, null, "%", "%");
                    sheet = reader.read(rs);
                    break;
                }
                case PROCEDURES: {
                    rs = metadata.getProcedures(null, null, "%");
                    sheet = reader.read(rs);
                    break;
                }
                case PSEUDO_COLUMNS: {
                    rs = metadata.getPseudoColumns(null, null, "%", "%");
                    sheet = reader.read(rs);
                    break;
                }
                case SCHEMAS: {
                    rs = metadata.getSchemas();
                    sheet = reader.read(rs);
                    break;
                }
                case SUPER_TABLES: {
                    rs = metadata.getSuperTables(null, null, "%");
                    sheet = reader.read(rs);
                    break;
                }
                case SUPER_TYPES: {
                    rs = metadata.getSuperTypes(null, null, "%");
                    sheet = reader.read(rs);
                    break;
                }
                case TABLE_TYPES: {
                    rs = metadata.getTableTypes();
                    sheet = reader.read(rs);
                    break;
                }
                case TABLES: {
                    rs = metadata.getTables(null, null, "%", null);
                    sheet = reader.read(rs);
                    break;
                }
                case TYPE_INFO: {
                    rs = metadata.getTypeInfo();
                    sheet = reader.read(rs);
                    break;
                }
                case USER_DEFINED_TYPES: {
                    rs = metadata.getUDTs(null, null, "%", null);
                    sheet = reader.read(rs);
                    break;
                }
                case VERSION_COLUMNS: {
                    rs = metadata.getVersionColumns(null, null, this.m_Table);
                    sheet = reader.read(rs);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled meta-data type: " + (Object)((Object)this.m_MetaDataType));
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to obtain database meta-data!", e);
        }
        if (sheet != null) {
            this.m_OutputToken = new Token(sheet);
        }
        return result;
    }

    public static enum MetaDataType {
        BASIC,
        CONNECTION,
        ATTRIBUTES,
        CATALOGS,
        CLIENT_INFO_PROPERTIES,
        COLUMN_PRIVILEGES,
        COLUMNS,
        EXPORTED_KEYS,
        FUNCTION_COLUMNS,
        FUNCTIONS,
        IMPORTED_KEYS,
        INDEX_INFO,
        PRIMARY_KEYS,
        PROCEDURE_COLUMNS,
        PROCEDURES,
        PSEUDO_COLUMNS,
        SCHEMAS,
        SUPER_TABLES,
        SUPER_TYPES,
        TABLES,
        TABLE_TYPES,
        TYPE_INFO,
        USER_DEFINED_TYPES,
        VERSION_COLUMNS;

    }
}

