/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.LookUpHelper;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.standalone.AbstractStandalone;
import adams.flow.transformer.LookUpAdd;

public class LookUpInit
extends AbstractStandalone
implements StorageUpdater,
ClassCrossReference {
    private static final long serialVersionUID = 8858771610997384634L;
    protected StorageName m_StorageName;

    public String globalInfo() {
        return "Initializes an empty look up table in storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{LookUpAdd.class};
    }

    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    protected String doExecute() {
        this.getStorageHandler().getStorage().put(this.m_StorageName, LookUpHelper.newTable());
        return null;
    }
}

