/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.LookUpHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.LookUpInit;
import java.util.HashMap;

public class LookUpAdd
extends AbstractTransformer {
    private static final long serialVersionUID = 7602201480653131469L;
    protected StorageName m_StorageName;
    protected SpreadSheetColumnIndex m_KeyColumn;
    protected SpreadSheetColumnIndex m_ValueColumn;
    protected boolean m_UseNative;

    public String globalInfo() {
        return "Adds key-value pairs to the specified lookup table.\nThe input can either an array or a spreadsheet.\nIf the input is an array, it must have length 2, with the first element the key and the second one the value. In case of a spreadsheet, the pairs are loaded using the specified columns.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("lookup"));
        this.m_OptionManager.add("key-column", "keyColumn", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value-column", "valueColumn", (Object)new SpreadSheetColumnIndex("2"));
        this.m_OptionManager.add("use-native", "useNative", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keyColumn", (Object)((Object)this.m_KeyColumn), (String)", key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"valueColumn", (Object)((Object)this.m_ValueColumn), (String)", value: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"useNative", (boolean)this.m_UseNative, (String)", native");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    public void setKeyColumn(SpreadSheetColumnIndex value) {
        this.m_KeyColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getKeyColumn() {
        return this.m_KeyColumn;
    }

    public String keyColumnTipText() {
        return "The index of the column in the spreadsheet to use as key; " + this.m_KeyColumn.getExample();
    }

    public void setValueColumn(SpreadSheetColumnIndex value) {
        this.m_ValueColumn = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getValueColumn() {
        return this.m_ValueColumn;
    }

    public String valueColumnTipText() {
        return "The index of the column in the spreadsheet to use as value; " + this.m_ValueColumn.getExample();
    }

    public void setUseNative(boolean value) {
        this.m_UseNative = value;
        this.reset();
    }

    public boolean getUseNative() {
        return this.m_UseNative;
    }

    public String useNativeTipText() {
        return "If enabled, native objects are used as value rather than strings.";
    }

    public Class[] accepts() {
        if (this.m_UseNative) {
            return new Class[]{Object[].class, SpreadSheet.class};
        }
        return new Class[]{String[].class, SpreadSheet.class};
    }

    public Class[] generates() {
        if (this.m_UseNative) {
            return new Class[]{Object[].class, SpreadSheet.class};
        }
        return new Class[]{String[].class, SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
            result = "Lookup table '" + this.m_StorageName + "' not available! Not initialized with " + LookUpInit.class.getName() + "?";
        } else {
            HashMap<String, Object> lookup = LookUpHelper.getTable((Actor)this, this.m_StorageName);
            if (this.m_InputToken.getPayload() instanceof SpreadSheet) {
                SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
                StringBuilder error = new StringBuilder();
                HashMap<String, Object> lookupAdd = LookUpHelper.load(sheet, this.m_KeyColumn.getIndex(), this.m_ValueColumn.getIndex(), this.m_UseNative, error);
                if (lookupAdd == null) {
                    result = error.toString();
                } else {
                    lookup.putAll(lookupAdd);
                    this.getStorageHandler().getStorage().put(this.m_StorageName, lookup);
                }
            } else {
                Object[] pair = (Object[])this.m_InputToken.getPayload();
                if (pair.length != 2) {
                    result = "Array must have length 2, provided: " + pair.length;
                } else {
                    String key = pair[0].toString();
                    Object value = pair[1];
                    if (this.isLoggingEnabled()) {
                        if (lookup.containsKey(key)) {
                            this.getLogger().info("Replacing: '" + key + "' -> '" + value + "'");
                        } else {
                            this.getLogger().info("Adding: '" + key + "' -> '" + value + "'");
                        }
                    }
                    lookup.put(key, value);
                }
            }
        }
        if (result == null) {
            this.m_OutputToken = this.m_InputToken;
        }
        return result;
    }
}

