/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.CellRange;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.Iterator;

public class SpreadSheetCellFinder
extends AbstractArrayProvider {
    private static final long serialVersionUID = 4527040722924866539L;
    protected CellFinder m_Finder;

    public String globalInfo() {
        return "Outputs the cell locations that the cell finder located.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new CellRange());
    }

    public String outputArrayTipText() {
        return "If enabled, outputs the row/column pairs as array instead of one-by-one";
    }

    protected Class getItemClass() {
        return CellLocation.class;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public void setFinder(CellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public CellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The column finder to use for identifying cells.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)"as array", (String)", ");
        if (value != null) {
            result = result == null ? value : result + value;
        }
        return result;
    }

    protected String doExecute() {
        this.m_Queue.clear();
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        Iterator<CellLocation> locs = this.m_Finder.findCells(sheet);
        while (locs.hasNext()) {
            this.m_Queue.add(locs.next());
        }
        return null;
    }
}

