/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.RowIdentifier;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import gnu.trove.set.hash.TIntHashSet;
import java.util.HashSet;
import java.util.List;

public class SpreadSheetCollapse
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 444466366407383727L;
    protected SpreadSheetColumnRange m_KeyColumns;
    protected String m_Separator;
    protected boolean m_NoDuplicates;

    public String globalInfo() {
        return "Uses the specified key columns to identify groups of rows. It then collapses these rows into a single one, concatenating the content of the cells. Optionally, duplicate cell values can be omitted.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-columns", "keyColumns", (Object)new SpreadSheetColumnRange("first"));
        this.m_OptionManager.add("separator", "separator", (Object)"");
        this.m_OptionManager.add("no-duplicates", "noDuplicates", (Object)false);
    }

    public void setKeyColumns(SpreadSheetColumnRange value) {
        this.m_KeyColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getKeyColumns() {
        return this.m_KeyColumns;
    }

    public String keyColumnsTipText() {
        return "The columns to use as keys for identifying rows in the spreadsheets; if left empty, all rows are used.";
    }

    public void setSeparator(String value) {
        this.m_Separator = value;
        this.reset();
    }

    public String getSeparator() {
        return this.m_Separator;
    }

    public String separatorTipText() {
        return "The separator to use when joining cell values.";
    }

    public void setNoDuplicates(boolean value) {
        this.m_NoDuplicates = value;
        this.reset();
    }

    public boolean getNoDuplicates() {
        return this.m_NoDuplicates;
    }

    public String noDuplicatesTipText() {
        return "If enabled, duplicate cell values get omitted.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"keyColumns", (Object)((Object)this.m_KeyColumns), (String)"key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"separator", (Object)(this.m_Separator.isEmpty() ? "-none-" : this.m_Separator), (String)", sep: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"noDuplicates", (boolean)this.m_NoDuplicates, (String)"no-dup", (String)", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet output = null;
        this.m_KeyColumns.setSpreadSheet(input);
        TIntHashSet keys = new TIntHashSet(this.m_KeyColumns.getIntIndices());
        if (keys.size() == 0) {
            result = "No key columns defined!";
        }
        RowIdentifier rows = new RowIdentifier((Range)this.m_KeyColumns);
        if (result == null) {
            rows.identify(input);
            output = input.getHeader();
            if (input.getRowCount() > 0) {
                HashSet<String> dups = new HashSet<String>();
                for (String key : rows.getKeys()) {
                    if (this.isStopped()) {
                        return null;
                    }
                    DataRow rowNew = output.addRow();
                    List subset = rows.getRows(key);
                    for (int index : keys.toArray()) {
                        rowNew.addCell(index).setContent(input.getRow(((Integer)subset.get(0)).intValue()).getCell(index).getContent());
                    }
                    for (int i = 0; i < input.getColumnCount(); ++i) {
                        if (keys.contains(i)) continue;
                        if (this.m_NoDuplicates) {
                            dups.clear();
                        }
                        StringBuilder collapsed = null;
                        Object object = subset.iterator();
                        while (object.hasNext()) {
                            int index = (Integer)object.next();
                            DataRow rowOld = input.getRow(index);
                            String content = rowOld.getContent(i);
                            if (this.m_NoDuplicates && dups.contains(content)) continue;
                            if (this.m_NoDuplicates) {
                                dups.add(content);
                            }
                            if (collapsed == null) {
                                collapsed = new StringBuilder();
                            } else {
                                collapsed.append(this.m_Separator);
                            }
                            collapsed.append(content);
                        }
                        if (collapsed != null) {
                            rowNew.addCell(i).setContentAsString(collapsed.toString());
                            continue;
                        }
                        rowNew.addCell(i).setMissing();
                    }
                }
            }
        }
        if (output != null) {
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

