/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.ArrayList;

public class SpreadSheetColumnsByName
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = -253714973019682939L;
    protected BaseRegExp m_RegExp;
    protected boolean m_InvertMatching;

    public String globalInfo() {
        return "Creates a new spreadsheet with the columns that matched the regular expression. It is possible to invert the matching sense as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reg-exp", "regExp", (Object)new BaseRegExp());
        this.m_OptionManager.add("invert-matching", "invertMatching", (Object)false);
    }

    public String getQuickInfo() {
        String result = "";
        if (this.m_InvertMatching && !QuickInfoHelper.hasVariable((OptionHandler)this, (String)"invertMatching")) {
            result = result + "not ";
        }
        result = result + "matching: ";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp);
        return result;
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the column names against.";
    }

    public void setInvertMatching(boolean value) {
        this.m_InvertMatching = value;
        this.reset();
    }

    public boolean getInvertMatching() {
        return this.m_InvertMatching;
    }

    public String invertMatchingTipText() {
        return "If enabled, the matching sense is inverted, ie, only non-matching columns get output.";
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            boolean add = this.m_InvertMatching ? !this.m_RegExp.isMatch(sheet.getHeaderRow().getCell(i).getContent()) : this.m_RegExp.isMatch(sheet.getHeaderRow().getCell(i).getContent());
            if (!add) continue;
            indices.add(i);
        }
        if (indices.size() > 0) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Output columns: " + indices);
            }
            SpreadSheet subset = sheet.newInstance();
            for (i = 0; i < indices.size(); ++i) {
                subset.getHeaderRow().addCell("" + (i + 1)).setContent(sheet.getHeaderRow().getCell(((Integer)indices.get(i)).intValue()).getContent());
            }
            for (int n = 0; n < sheet.getRowCount(); ++n) {
                DataRow row = sheet.getRow(n);
                DataRow subrow = subset.addRow("" + subset.getRowCount());
                for (i = 0; i < indices.size(); ++i) {
                    subrow.addCell("" + (i + 1)).assign(row.getCell(((Integer)indices.get(i)).intValue()));
                }
            }
            this.m_OutputToken = new Token((Object)subset);
        } else if (this.isLoggingEnabled()) {
            this.getLogger().info("No columns for output!");
        }
        return result;
    }
}

