/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetRemoveRow
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -1424259429280086410L;
    protected Range m_Position;

    public String globalInfo() {
        return "Removes one or more rows at the specific position from spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new Range();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)new Range("first-last"));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)this.m_Position, (String)"range: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setPosition(Range value) {
        this.m_Position = value;
        this.reset();
    }

    public Range getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position of the rows to remove.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (!this.m_NoCopy) {
            sheet = sheet.getClone();
        }
        this.m_Position.setMax(sheet.getRowCount());
        int[] indices = this.m_Position.getIntIndices();
        if (indices.length > 0) {
            for (int i = indices.length - 1; i >= 0; --i) {
                sheet.removeRow(indices[i]);
            }
            this.m_OutputToken = new Token((Object)sheet);
        } else {
            result = "Failed to located row(s): " + this.m_Position.getRange();
        }
        return result;
    }
}

