/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.ArrayList;

public class SpreadSheetReorderColumns
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = -6140158624456525670L;
    protected String m_Order;

    public String globalInfo() {
        return "Reorders the columns in a spreadsheet according to a user-supplied order. Columns can be supplied either by name or index (1-based). Depending on whether you use a column multiple times or omit it, you effectively duplicate it or remove it from the final spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("order", "order", (Object)"first-last");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"order", (Object)this.m_Order);
    }

    public void setOrder(String value) {
        this.m_Order = value;
        this.reset();
    }

    public String getOrder() {
        return this.m_Order;
    }

    public String orderTipText() {
        return "The new order for the columns; " + new SpreadSheetColumnRange().getExample();
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Order.trim().length() == 0) {
            result = "No new column order provided!";
        }
        if (result == null) {
            int i;
            String[] ranges;
            SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
            SpreadSheet output = input.newInstance();
            output.setDataRowClass(input.getDataRowClass());
            for (String comment : input.getComments()) {
                output.addComment(comment);
            }
            ArrayList indices = new ArrayList();
            for (String r : ranges = SpreadSheetUtils.split((String)this.m_Order, (char)',')) {
                SpreadSheetColumnRange range = new SpreadSheetColumnRange(r);
                range.setSpreadSheet(input);
                indices.addAll(Utils.toList((int[])range.getIntIndices()));
            }
            HeaderRow rowOld = input.getHeaderRow();
            HeaderRow rowNew = output.getHeaderRow();
            for (i = 0; i < indices.size(); ++i) {
                rowNew.addCell("" + i).setContent(rowOld.getContent(((Integer)indices.get(i)).intValue()));
            }
            for (int n = 0; n < input.getRowCount(); ++n) {
                rowOld = input.getRow(n);
                rowNew = output.addRow();
                for (i = 0; i < indices.size(); ++i) {
                    if (!rowOld.hasCell(((Integer)indices.get(i)).intValue())) continue;
                    rowNew.addCell("" + i).setContent(rowOld.getContent(((Integer)indices.get(i)).intValue()));
                }
            }
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

