/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class SpreadSheetRowBuffer
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = 6774529845778672623L;
    public static final String BACKUP_BUFFER = "buffer";
    public static final String BACKUP_ITERATOR = "iterator";
    protected SpreadSheet m_Buffer;
    protected Iterator<DataRow> m_Iterator;
    protected Operation m_Operation;
    protected boolean m_CheckHeader;
    protected int m_Interval;
    protected boolean m_ClearBuffer;

    public String globalInfo() {
        return "Can act in two different ways:\n1. Row -> SpreadSheet\nBuffers " + Row.class.getName() + " objects and outputs a " + SpreadSheet.class.getName() + " object, whenever the interval condition has been met.\n2. SpreadSheet -> Row\nOutputs all the " + Row.class.getName() + " objects that the incoming " + SpreadSheet.class.getName() + " object contains.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)Operation.ROW_TO_SPREADSHEET);
        this.m_OptionManager.add("check", "checkHeader", (Object)false);
        this.m_OptionManager.add("interval", "interval", (Object)1, (Number)1, null);
        this.m_OptionManager.add("clear-buffer", "clearBuffer", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"interval", (Object)this.m_Interval, (String)", interval: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"checkHeader", (boolean)this.m_CheckHeader, (String)"check header"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"clearBuffer", (boolean)this.m_ClearBuffer, (String)"clear"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setOperation(Operation value) {
        this.m_Operation = value;
        this.reset();
    }

    public Operation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The way the buffer operates.";
    }

    public void setCheckHeader(boolean value) {
        this.m_CheckHeader = value;
        this.reset();
    }

    public boolean getCheckHeader() {
        return this.m_CheckHeader;
    }

    public String checkHeaderTipText() {
        return "Whether to check the headers - if the headers change, the Row object gets added to a new spreadsheet (in case of " + (Object)((Object)Operation.ROW_TO_SPREADSHEET) + ").";
    }

    public void setInterval(int value) {
        this.m_Interval = value;
        this.reset();
    }

    public int getInterval() {
        return this.m_Interval;
    }

    public String intervalTipText() {
        return "The interval at which to output the SpreadSheet object (in case of " + (Object)((Object)Operation.ROW_TO_SPREADSHEET) + ").";
    }

    public void setClearBuffer(boolean value) {
        this.m_ClearBuffer = value;
        this.reset();
    }

    public boolean getClearBuffer() {
        return this.m_ClearBuffer;
    }

    public String clearBufferTipText() {
        return "Whether to clear the buffer once the dataset has been forwarded (in case of " + (Object)((Object)Operation.ROW_TO_SPREADSHEET) + ").";
    }

    public Class[] accepts() {
        if (this.m_Operation == Operation.ROW_TO_SPREADSHEET) {
            return new Class[]{Row.class, Row[].class};
        }
        if (this.m_Operation == Operation.SPREADSHEET_TO_ROW) {
            return new Class[]{SpreadSheet.class};
        }
        throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
    }

    public Class[] generates() {
        if (this.m_Operation == Operation.ROW_TO_SPREADSHEET) {
            return new Class[]{SpreadSheet.class};
        }
        if (this.m_Operation == Operation.SPREADSHEET_TO_ROW) {
            return new Class[]{Row.class};
        }
        throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_BUFFER);
        this.pruneBackup(BACKUP_ITERATOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Buffer != null) {
            result.put(BACKUP_BUFFER, this.m_Buffer);
        }
        if (this.m_Iterator != null) {
            result.put(BACKUP_ITERATOR, this.m_Iterator);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_BUFFER)) {
            this.m_Buffer = (SpreadSheet)state.get(BACKUP_BUFFER);
            state.remove(BACKUP_BUFFER);
        }
        if (state.containsKey(BACKUP_ITERATOR)) {
            this.m_Iterator = (Iterator)state.get(BACKUP_ITERATOR);
            state.remove(BACKUP_ITERATOR);
        }
        super.restoreState(state);
    }

    protected void reset() {
        super.reset();
        this.m_Buffer = null;
        this.m_Iterator = null;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Operation == Operation.ROW_TO_SPREADSHEET) {
            Row[] rows = this.m_InputToken.getPayload() instanceof Row ? new Row[]{(Row)this.m_InputToken.getPayload()} : (Row[])this.m_InputToken.getPayload();
            for (int n = 0; n < rows.length; ++n) {
                String msg;
                Row row = rows[n];
                if (this.m_Buffer != null && this.m_CheckHeader && (msg = this.m_Buffer.equalsHeader(row.getOwner())) != null) {
                    this.getLogger().info("Header changed, resetting buffer: " + msg);
                    this.m_Buffer = null;
                }
                if (this.m_Buffer == null) {
                    this.m_Buffer = row.getOwner().getHeader();
                }
                this.m_Buffer.addRow().assign(row);
            }
            if (this.m_Buffer.getRowCount() % this.m_Interval == 0) {
                this.m_OutputToken = new Token((Object)this.m_Buffer);
                if (this.m_ClearBuffer) {
                    this.m_Buffer = null;
                }
            }
        } else if (this.m_Operation == Operation.SPREADSHEET_TO_ROW) {
            this.m_Buffer = (SpreadSheet)this.m_InputToken.getPayload();
            this.m_Iterator = this.m_Buffer.rows().iterator();
        } else {
            throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
        }
        return result;
    }

    public boolean hasPendingOutput() {
        if (this.m_Operation == Operation.ROW_TO_SPREADSHEET) {
            return super.hasPendingOutput();
        }
        if (this.m_Operation == Operation.SPREADSHEET_TO_ROW) {
            return this.m_Iterator != null && this.m_Iterator.hasNext();
        }
        throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
    }

    public Token output() {
        Token result;
        if (this.m_Operation == Operation.ROW_TO_SPREADSHEET) {
            result = this.m_OutputToken;
            this.m_OutputToken = null;
        } else if (this.m_Operation == Operation.SPREADSHEET_TO_ROW) {
            result = new Token((Object)this.m_Iterator.next());
        } else {
            throw new IllegalStateException("Unhandled operation: " + (Object)((Object)this.m_Operation));
        }
        this.updateProvenance((ProvenanceContainer)result);
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, ((Token)cont).getPayload().getClass()));
        }
    }

    public void wrapUp() {
        this.m_Iterator = null;
        this.m_Buffer = null;
        super.wrapUp();
    }

    public static enum Operation {
        SPREADSHEET_TO_ROW,
        ROW_TO_SPREADSHEET;

    }
}

