/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetSetHeaderCell
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -6250232085303020849L;
    protected SpreadSheetColumnIndex m_Column;
    protected String m_Value;
    protected boolean m_ForceString;

    public String globalInfo() {
        return "Sets a single header cell value in a spreadsheet.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("col", "column", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("value", "value", (Object)"");
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Column = new SpreadSheetColumnIndex();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)("'" + this.m_Value + "'"), (String)", value: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"forceString", (boolean)this.m_ForceString, (String)"force string", (String)", ");
        return result;
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the header cell to set; " + this.m_Column.getExample();
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the header cell.";
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the value is set as string, even if it resembles a number.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (!this.m_NoCopy) {
            sheet = sheet.getClone();
        }
        this.m_Column.setSpreadSheet(sheet);
        if (this.m_Column.getIntIndex() == -1) {
            result = "Illegal column index ('" + this.m_Column.getIndex() + "')?";
            this.m_OutputToken = new Token((Object)sheet);
        } else {
            HeaderRow row = sheet.getHeaderRow();
            Cell cell = row.getCell(this.m_Column.getIntIndex());
            if (cell == null) {
                cell = row.addCell(this.m_Column.getIntIndex());
            }
            if (this.m_ForceString) {
                cell.setContentAsString(this.m_Value);
            } else {
                cell.setContent(this.m_Value);
            }
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

