/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class XYPlotGenerator
extends AbstractPlotGenerator {
    private static final long serialVersionUID = 2881757430571628883L;
    protected SpreadSheetColumnRange m_PlotColumns;
    protected SpreadSheetColumnIndex m_XColumn;
    protected SpreadSheetColumnRange m_PrefixColumns;
    protected String m_Separator;
    protected SpreadSheetColumnRange m_MetaDataColumns;

    public String globalInfo() {
        return "Uses one column for the X value and one or more other columns as Y to plot against.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "plotColumns", (Object)"");
        this.m_OptionManager.add("x-column", "XColumn", (Object)"");
        this.m_OptionManager.add("prefix-columns", "prefixColumns", (Object)new SpreadSheetColumnRange());
        this.m_OptionManager.add("separator", "separator", (Object)" ");
        this.m_OptionManager.add("meta-data-columns", "metaDataColumns", (Object)"");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PlotColumns = new SpreadSheetColumnRange();
        this.m_XColumn = new SpreadSheetColumnIndex();
        this.m_MetaDataColumns = new SpreadSheetColumnRange();
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"XColumn", (Object)(this.getXColumn().isEmpty() ? "-none-" : this.getXColumn()), (String)", x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"plotColumns", (Object)(this.getPlotColumns().isEmpty() ? "-none-" : this.getPlotColumns()), (String)", y cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"prefixColumns", (Object)(this.getPrefixColumns().isEmpty() ? "-none-" : this.getPrefixColumns()), (String)", prefix cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"separator", (Object)this.getSeparator(), (String)", separator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataColumns", (Object)(this.getMetaDataColumns().isEmpty() ? "-none-" : this.getMetaDataColumns()), (String)", meta-data: ");
        return result;
    }

    public void setPlotColumns(String value) {
        this.m_PlotColumns.setRange(value);
        this.reset();
    }

    public String getPlotColumns() {
        return this.m_PlotColumns.getRange();
    }

    public String plotColumnsTipText() {
        return "The range of columns to include in the plot; " + this.m_PlotColumns.getExample();
    }

    public void setXColumn(String value) {
        this.m_XColumn.setIndex(value);
        this.reset();
    }

    public String getXColumn() {
        return this.m_XColumn.getIndex();
    }

    public String XColumnTipText() {
        return "The (optional) index of the column which values to use as X values in the plot; " + this.m_XColumn.getExample();
    }

    public void setPrefixColumns(SpreadSheetColumnRange value) {
        this.m_PrefixColumns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getPrefixColumns() {
        return this.m_PrefixColumns;
    }

    public String prefixColumnsTipText() {
        return "The range of columns to prefix the plot name with; " + this.m_PlotColumns.getExample();
    }

    public void setSeparator(String value) {
        this.m_Separator = value;
        this.reset();
    }

    public String getSeparator() {
        return this.m_Separator;
    }

    public String separatorTipText() {
        return "The separator to use between columns.";
    }

    public void setMetaDataColumns(String value) {
        this.m_MetaDataColumns.setRange(value);
        this.reset();
    }

    public String getMetaDataColumns() {
        return this.m_MetaDataColumns.getRange();
    }

    public String metaDataColumnsTipText() {
        return "The range of columns to add as meta-data in the plot; " + this.m_MetaDataColumns.getExample();
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_PlotColumns.setSpreadSheet(sheet);
        if (this.m_PlotColumns.getIntIndices().length == 0) {
            throw new IllegalStateException("No plot columns defined/available?");
        }
        this.m_XColumn.setSpreadSheet(sheet);
        if (this.m_XColumn.getIntIndex() == -1) {
            throw new IllegalStateException("No X column defined/available?");
        }
        this.m_PrefixColumns.setSpreadSheet(sheet);
        this.m_MetaDataColumns.setSpreadSheet(sheet);
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        int i;
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int xIndex = this.m_XColumn.getIntIndex();
        int[] plotCols = this.m_PlotColumns.getIntIndices();
        String[] plotNames = new String[plotCols.length];
        int[] prefixCols = this.m_PrefixColumns.getIntIndices();
        int[] metaCols = this.m_MetaDataColumns.getIntIndices();
        for (i = 0; i < plotNames.length; ++i) {
            plotNames[i] = sheet.getHeaderRow().getCell(plotCols[i]).getContent();
        }
        for (i = 0; i < sheet.getRowCount(); ++i) {
            int n;
            DataRow row = sheet.getRow(i);
            String prefix = "";
            if (prefixCols.length > 0) {
                for (n = 0; n < prefixCols.length; ++n) {
                    if (n > 0) {
                        prefix = prefix + this.m_Separator;
                    }
                    prefix = row.hasCell(prefixCols[n]) ? prefix + row.getCell(prefixCols[n]).getContent() : prefix + "?";
                }
                prefix = prefix + " ";
            }
            for (n = 0; n < plotCols.length; ++n) {
                SequencePlotterContainer cont;
                if (xIndex == -1) {
                    cont = new SequencePlotterContainer(this.getActualPlotName((Row)row, prefix + plotNames[n]), (Comparable)new Double(i), this.getCellValue((Row)row, plotCols[n]));
                } else {
                    if (xIndex == plotCols[n]) continue;
                    cont = new SequencePlotterContainer(this.getActualPlotName((Row)row, prefix + plotNames[n]), this.getCellValue((Row)row, xIndex), this.getCellValue((Row)row, plotCols[n]));
                }
                for (int m = 0; m < metaCols.length; ++m) {
                    cont.addMetaData(sheet.getColumnName(metaCols[m]), this.getCellObject((Row)row, metaCols[m], null));
                }
                result.add(cont);
            }
        }
        return result;
    }
}

