/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.SpreadSheetWriter;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.chooser.SpreadSheetFileChooser;
import java.awt.Component;
import java.io.File;

public class SpreadSheetFileChooserPanel
extends FileChooserPanel {
    private static final long serialVersionUID = -8755020252465094120L;
    protected SpreadSheetFileChooser m_FileChooser;
    protected SpreadSheetReader m_Reader;
    protected SpreadSheetWriter m_Writer;

    public SpreadSheetFileChooserPanel() {
        this("");
    }

    public SpreadSheetFileChooserPanel(String path) {
        this((File)new PlaceholderFile(path));
    }

    public SpreadSheetFileChooserPanel(File path) {
        super(path);
        this.initializeConverters(path);
    }

    protected void initializeConverters(File path) {
        if (path.length() > 0L && path.isFile()) {
            this.m_Reader = this.m_FileChooser.getReaderForFile(path.getAbsoluteFile());
            this.m_Writer = this.m_FileChooser.getWriterForFile(path.getAbsoluteFile());
        } else {
            this.m_Reader = null;
            this.m_Writer = null;
        }
    }

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new SpreadSheetFileChooser();
        this.m_Reader = null;
        this.m_Writer = null;
    }

    protected File doChoose() {
        this.m_FileChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        if (!this.m_UseSaveDialog) {
            if (this.m_FileChooser.showOpenDialog((Component)this.m_Self) == 0) {
                this.m_Reader = (SpreadSheetReader)this.m_FileChooser.getReader();
                this.m_Writer = null;
                return new PlaceholderFile(this.m_FileChooser.getSelectedFile());
            }
            return null;
        }
        if (this.m_FileChooser.showSaveDialog((Component)this.m_Self) == 0) {
            this.m_Reader = null;
            this.m_Writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
            return new PlaceholderFile(this.m_FileChooser.getSelectedFile());
        }
        return null;
    }

    public SpreadSheetReader getReader() {
        return this.m_Reader;
    }

    public SpreadSheetWriter getWriter() {
        return this.m_Writer;
    }

    public void setCurrentDirectory(File value) {
        this.m_FileChooser.setCurrentDirectory(value.getAbsoluteFile());
    }

    public File getCurrentDirectory() {
        return new PlaceholderFile(this.m_FileChooser.getCurrentDirectory());
    }

    public boolean setCurrent(File value) {
        boolean result = super.setCurrent(value);
        this.initializeConverters((File)this.getCurrent());
        this.m_FileChooser.setSelectedFile(((File)this.getCurrent()).getAbsoluteFile());
        return result;
    }
}

