/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.conversion.SpreadSheetAnyColumnToString;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.spreadsheettable.AbstractProcessColumn;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.table.TableModel;

public class ChangeColumnType
extends AbstractProcessColumn {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Allows the user to change the type of a column.";
    }

    public String getMenuItem() {
        return "Change column type...";
    }

    protected boolean doProcessColumn(SpreadSheetTable table, SpreadSheet sheet, int column) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)table) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)table), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(AbstractSpreadSheetColumnConverter.class);
        setup.getGOEEditor().setCanChangeClassInDialog(true);
        AbstractSpreadSheetColumnConverter last = (AbstractSpreadSheetColumnConverter)((Object)table.getLastSetup(((Object)((Object)this)).getClass(), true, false));
        if (last == null) {
            last = new SpreadSheetAnyColumnToString();
        }
        last.setNoCopy(true);
        last.setColumn(new SpreadSheetColumnIndex("" + (column + 1)));
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return false;
        }
        last = (AbstractSpreadSheetColumnConverter)((Object)setup.getCurrent());
        last.setNoCopy(true);
        last.setColumn(new SpreadSheetColumnIndex("" + (column + 1)));
        table.addLastSetup(((Object)((Object)this)).getClass(), true, false, (Object)last);
        last.setInput(sheet);
        String msg = last.convert();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)table), (String)("Failed to convert column: " + msg));
        } else {
            sheet = (SpreadSheet)last.getOutput();
            table.setModel((TableModel)new SpreadSheetTableModel(sheet));
        }
        last.cleanUp();
        return msg == null;
    }
}

