/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.colstatistic.AbstractColumnStatistic;
import adams.data.spreadsheet.colstatistic.Mean;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractProcessColumn;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;

public class ColumnStatistic
extends AbstractProcessColumn {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Allows the user to calculate statistics for a column.";
    }

    public String getMenuItem() {
        return "Column statistics...";
    }

    protected boolean doProcessColumn(SpreadSheetTable table, SpreadSheet sheet, int column) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)table) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)table), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(AbstractColumnStatistic.class);
        setup.getGOEEditor().setCanChangeClassInDialog(true);
        AbstractColumnStatistic last = (AbstractColumnStatistic)((Object)table.getLastSetup(((Object)((Object)this)).getClass(), true, false));
        if (last == null) {
            last = new Mean();
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return false;
        }
        last = (AbstractColumnStatistic)((Object)setup.getCurrent());
        table.addLastSetup(((Object)((Object)this)).getClass(), true, false, (Object)last);
        SpreadSheet stats = last.generate(sheet, column);
        if (stats == null) {
            if (last.hasLastError()) {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)table), (String)("Failed to calculate statistics for column #" + (column + 1) + ": " + last.getLastError()));
            } else {
                GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)table), (String)("Failed to calculate statistics for column #" + (column + 1) + "!"));
            }
        } else {
            SpreadSheetDialog dialog = GUIHelper.getParentDialog((Container)table) != null ? new SpreadSheetDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(GUIHelper.getParentFrame((Container)table), false);
            dialog.setDefaultCloseOperation(2);
            dialog.setTitle("Statistics for column #" + (column + 1) + "/" + sheet.getColumnName(column));
            dialog.setSpreadSheet(stats);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
        }
        return stats != null;
    }
}

