/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.sink.JFreeChartPlot;
import adams.flow.source.StorageValue;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.PlotColumn;
import adams.gui.core.spreadsheettable.PlotRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.swing.SwingWorker;

public class JFreeChart
extends AbstractOptionHandler
implements PlotColumn,
PlotRow {
    private static final long serialVersionUID = -5624002368001818142L;
    public static final int MAX_POINTS = 1000;

    public String globalInfo() {
        return "Allows to generate a JFreeChart plot from a spreadsheet row or column";
    }

    public String getMenuItem() {
        return "JFreeChart...";
    }

    public String getIconName() {
        return "jfreechart.gif";
    }

    public int compareTo(SpreadSheetTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    protected void plot(final SpreadSheetTable table, SpreadSheet sheet, final boolean isColumn, int index) {
        List list;
        int i;
        int numPoints;
        int n = numPoints = isColumn ? sheet.getRowCount() : sheet.getColumnCount();
        if (numPoints > 1000) {
            String newPoints = GUIHelper.showInputDialog(null, (String)"More than 1000 data points to plot - enter sample size:", (String)("" + numPoints));
            if (newPoints == null) {
                return;
            }
            if (!Utils.isInteger((String)newPoints)) {
                return;
            }
            if (Integer.parseInt(newPoints) != numPoints) {
                numPoints = Integer.parseInt(newPoints);
            }
        } else {
            numPoints = -1;
        }
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)table) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)table), true);
        setup.setDefaultCloseOperation(2);
        setup.getGOEEditor().setClassType(Actor.class);
        setup.getGOEEditor().setCanChangeClassInDialog(false);
        JFreeChartPlot last = (JFreeChartPlot)((Object)table.getLastSetup(((Object)((Object)this)).getClass(), true, !isColumn));
        if (last == null) {
            last = new JFreeChartPlot();
        }
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return;
        }
        last = (JFreeChartPlot)((Object)setup.getCurrent());
        table.addLastSetup(((Object)((Object)this)).getClass(), true, !isColumn, (Object)last);
        ArrayList<Double> tmp = new ArrayList<Double>();
        boolean sorted = false;
        boolean asc = table.isAscending();
        if (isColumn) {
            int col = index;
            if (table.getShowRowColumn()) {
                ++col;
            }
            sorted = table.getSortColumn() == col;
            for (i = 0; i < table.getRowCount(); ++i) {
                Object value = table.getValueAt(i, col);
                if (value == null || !Utils.isDouble((String)value.toString())) continue;
                tmp.add(Utils.toDouble((String)value.toString()));
            }
        } else {
            int row = index;
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                Cell cell;
                if (!sheet.getRow(row).hasCell(i) || (cell = sheet.getRow(row).getCell(i)).isMissing() || !cell.isNumeric()) continue;
                tmp.add(cell.toDouble());
            }
        }
        if (numPoints > -1) {
            numPoints = Math.min(numPoints, tmp.size());
            Collections.shuffle(tmp, new Random(1L));
            list = tmp.subList(0, numPoints);
            if (sorted) {
                Collections.sort(list);
                if (!asc) {
                    Collections.reverse(list);
                }
            }
        } else {
            list = tmp;
        }
        DefaultSpreadSheet data = new DefaultSpreadSheet();
        data.getHeaderRow().addCell("x").setContentAsString(isColumn ? "Row" : "Column");
        data.getHeaderRow().addCell("y").setContentAsString(isColumn ? sheet.getColumnName(index) : "Row " + (index + 2));
        for (i = 0; i < list.size(); ++i) {
            DataRow srow = data.addRow();
            srow.addCell("x").setContent(Double.valueOf((double)i + 1.0));
            srow.addCell("y").setContent((Double)list.get(i));
        }
        final String title = isColumn ? "Column " + (index + 1) + "/" + sheet.getColumnName(index) : "Row " + (index + 2);
        last.getChart().setTitle(data.getColumnName(1));
        SwingWorker worker = new SwingWorker((SpreadSheet)data){
            final /* synthetic */ SpreadSheet val$data;
            {
                this.val$data = spreadSheet;
            }

            protected Object doInBackground() throws Exception {
                Flow flow = new Flow();
                flow.setDefaultCloseOperation(2);
                StorageValue sv = new StorageValue();
                sv.setStorageName(new StorageName("values"));
                flow.add((Actor)sv);
                Object last = table.getLastSetup(((Object)((Object)JFreeChart.this)).getClass(), true, !isColumn);
                JFreeChartPlot plot = (JFreeChartPlot)((JFreeChartPlot)((Object)last)).shallowCopy();
                plot.setShortTitle(true);
                plot.setName(title);
                plot.setX(-2);
                plot.setY(-2);
                flow.add((Actor)plot);
                flow.setUp();
                flow.getStorage().put(new StorageName("values"), (Object)this.val$data);
                flow.execute();
                flow.wrapUp();
                return null;
            }
        };
        worker.execute();
    }

    public boolean plotColumn(SpreadSheetTable table, SpreadSheet sheet, int column) {
        this.plot(table, sheet, true, column);
        return true;
    }

    public boolean plotRow(SpreadSheetTable table, SpreadSheet sheet, int actRow, int selRow) {
        this.plot(table, sheet, false, actRow);
        return true;
    }
}

