/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.tools.spreadsheetviewer.AbstractSelectedSheetsDataPlugin;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import javax.swing.JPanel;

public class Append
extends AbstractSelectedSheetsDataPlugin {
    private static final long serialVersionUID = -407256934764293407L;

    public String globalInfo() {
        return "Appends the selected spreadsheets into a single spreadsheet, one after the other.";
    }

    @Override
    public String getMenuText() {
        return "Append...";
    }

    @Override
    public String getMenuIcon() {
        return "append.png";
    }

    @Override
    public boolean isInPlace() {
        return false;
    }

    @Override
    public boolean canProcess(SpreadSheetPanel panel) {
        return super.canProcess(panel) && panel.getOwner().getTabCount() > 1;
    }

    @Override
    protected JPanel createConfigurationPanel(ApprovalDialog dialog) {
        return null;
    }

    @Override
    protected SpreadSheet process() {
        if (this.m_SelectedPanels.length < 2) {
            this.getLogger().warning("At least two panels must be selected!");
            return null;
        }
        SpreadSheet result = this.m_SelectedPanels[0].getSheet().getClone();
        for (int i = 1; i < this.m_SelectedPanels.length; ++i) {
            result = SpreadSheetHelper.append(result, this.m_SelectedPanels[i].getSheet(), true);
        }
        return result;
    }
}

