/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.menu;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.core.Actor;
import adams.flow.transformer.SpreadSheetDifference;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.menu.AbstractSpreadSheetViewerMenuItemAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class DataComputeDifference
extends AbstractSpreadSheetViewerMenuItemAction {
    private static final long serialVersionUID = 5235570137451285010L;

    protected String getTitle() {
        return "Compute difference...";
    }

    protected void computeDifference(SpreadSheet sheet1, SpreadSheet sheet2, SpreadSheetColumnRange keyCols) {
        if (sheet1 == null || sheet2 == null) {
            return;
        }
        SpreadSheetDifference filter = new SpreadSheetDifference();
        filter.setKeyColumns(keyCols);
        ((SpreadSheetViewerPanel)((Object)this.m_State)).filterData(this.getTabbedPane().newTitle(), new SpreadSheet[]{sheet1, sheet2}, (Actor)filter);
    }

    protected void doActionPerformed(ActionEvent e) {
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getParentFrame(), true);
        dialog.setTitle("Compute difference");
        ParameterPanel params = new ParameterPanel();
        dialog.getContentPane().add((Component)params, "Center");
        List<String> titles = this.getTabbedPane().getTabTitles();
        JComboBox<String> sheet1 = new JComboBox<String>(titles.toArray(new String[titles.size()]));
        params.addParameter("First sheet", sheet1);
        params.addParameter("", (Component)new JLabel("minus"));
        JComboBox<String> sheet2 = new JComboBox<String>(titles.toArray(new String[titles.size()]));
        params.addParameter("Second sheet", sheet2);
        params.addParameter("", (Component)new JLabel("using"));
        JTextField range = new JTextField(10);
        range.setText("");
        range.setToolTipText(new SpreadSheetColumnRange().getExample());
        params.addParameter("Key columns", (Component)range);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)this.m_State);
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        if (sheet1.getSelectedIndex() == sheet2.getSelectedIndex()) {
            GUIHelper.showErrorMessage((Component)((Component)this.m_State), (String)"You must select two different spreadsheets!");
            return;
        }
        this.computeDifference(this.getTabbedPane().getSheetAt(sheet1.getSelectedIndex()), this.getTabbedPane().getSheetAt(sheet2.getSelectedIndex()), new SpreadSheetColumnRange(range.getText()));
    }

    protected void doUpdate() {
        this.setEnabled(this.getTabbedPane().getTabCount() >= 2);
    }
}

