/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.AbstractContainer;
import adams.gui.visualization.container.AbstractContainerManager;
import adams.gui.visualization.container.ColorContainerManager;
import adams.gui.visualization.container.ContainerListManager;
import adams.gui.visualization.container.NamedContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.ColorProviderWithNameSupport;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainer;
import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class SpreadSheetRowContainerManager
extends AbstractContainerManager<SpreadSheetRowContainer>
implements VisibilityContainerManager<SpreadSheetRowContainer>,
NamedContainerManager,
ColorContainerManager<SpreadSheetRowContainer> {
    private static final long serialVersionUID = -4325235760470150191L;
    protected ContainerListManager<SpreadSheetRowContainerManager> m_Owner;
    protected ColorProvider m_ColorProvider;

    public SpreadSheetRowContainerManager(ContainerListManager<SpreadSheetRowContainerManager> owner) {
        this.m_Owner = owner;
        this.m_ColorProvider = new DefaultColorProvider();
        this.m_FilteredList = null;
        if (owner instanceof DataChangeListener) {
            this.addDataChangeListener((DataChangeListener)owner);
        }
    }

    public ContainerListManager getOwner() {
        return this.m_Owner;
    }

    public synchronized void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        for (int i = 0; i < this.count(); ++i) {
            ((SpreadSheetRowContainer)this.get(i)).setColor(this.getColor((SpreadSheetRowContainer)this.get(i)));
        }
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public Color getColor(SpreadSheetRowContainer cont) {
        if (this.m_ColorProvider instanceof ColorProviderWithNameSupport) {
            return ((ColorProviderWithNameSupport)this.m_ColorProvider).next(cont.getID());
        }
        return this.m_ColorProvider.next();
    }

    public void clear() {
        this.m_FilteredList = null;
        super.clear();
        this.m_ColorProvider.resetColors();
    }

    public SpreadSheetRowContainer newContainer(Comparable o) {
        return new SpreadSheetRowContainer(this, (SpreadSheetRow)((Object)o));
    }

    public void add(SpreadSheetRowContainer c) {
        c.setColor(this.getColor(c));
        super.add((AbstractContainer)c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
    }

    public SpreadSheetRowContainer set(int index, SpreadSheetRowContainer c) {
        SpreadSheetRowContainer result = (SpreadSheetRowContainer)super.set(index, (AbstractContainer)c);
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
        return result;
    }

    public SpreadSheetRowContainer remove(int index) {
        if (!this.m_AllowRemoval) {
            return null;
        }
        SpreadSheetRowContainer result = (SpreadSheetRowContainer)super.remove(index);
        this.m_ColorProvider.recycle(result.getColor());
        if (!this.m_Updating && this.updateSearchOnUpdate()) {
            this.updateSearch();
        }
        return result;
    }

    public int indexOf(String id) {
        int result = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (!((SpreadSheetRowContainer)this.get(i)).getID().equals(id)) continue;
            result = i;
            break;
        }
        return result;
    }

    public int[] getVisibleIndices() {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    public List<SpreadSheetRowContainer> getAllVisible() {
        ArrayList<SpreadSheetRowContainer> result = new ArrayList<SpreadSheetRowContainer>();
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            SpreadSheetRowContainer cont = (SpreadSheetRowContainer)((SpreadSheetRowContainer)this.get(i)).copy();
            cont.setManager(null);
            result.add(cont);
        }
        return result;
    }

    public boolean isVisible(int index) {
        return ((SpreadSheetRowContainer)this.get(index)).isVisible();
    }

    public void setVisible(int index, boolean visible) {
        ((SpreadSheetRowContainer)this.get(index)).setVisible(visible);
        this.notifyDataChangeListeners(new DataChangeEvent((AbstractContainerManager)this, DataChangeEvent.Type.VISIBILITY, index));
    }

    public SpreadSheetRowContainer getVisible(int index) {
        SpreadSheetRowContainer result = null;
        int count = -1;
        for (int i = 0; i < this.count(); ++i) {
            if (this.isVisible(i)) {
                ++count;
            }
            if (count != index) continue;
            result = (SpreadSheetRowContainer)this.get(i);
            break;
        }
        return result;
    }

    public int countVisible() {
        int result = 0;
        for (int i = 0; i < this.count(); ++i) {
            if (!this.isVisible(i)) continue;
            ++result;
        }
        return result;
    }

    protected boolean isMatch(SpreadSheetRowContainer cont, String search, boolean regExp) {
        if (regExp) {
            return cont.getID().matches(search);
        }
        return cont.getID().toLowerCase().contains(search);
    }
}

