/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractConversionTestCase;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetAnyColumnToString;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.env.Environment;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetAnyColumnToStringTest
extends AbstractConversionTestCase {
    public SpreadSheetAnyColumnToStringTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("double.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("double.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    protected Object[] getRegressionInput() {
        Object[] result;
        TmpFile file = new TmpFile("double.csv");
        try {
            CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
            reader.setTextColumns(new Range("first-last"));
            result = new SpreadSheet[]{reader.read((File)file)};
        }
        catch (Exception e) {
            result = new SpreadSheet[]{};
            SpreadSheetAnyColumnToStringTest.fail((String)("Failed to load data from '" + file + "': " + e));
        }
        return result;
    }

    protected Conversion[] getRegressionSetups() {
        SpreadSheetAnyColumnToString[] result = new SpreadSheetAnyColumnToString[2];
        result[0] = new SpreadSheetAnyColumnToString();
        result[0].setColumn(new SpreadSheetColumnIndex("2"));
        result[1] = new SpreadSheetAnyColumnToString();
        result[1].setColumn(new SpreadSheetColumnIndex("3"));
        return result;
    }

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetAnyColumnToStringTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetAnyColumnToStringTest.runTest((Test)SpreadSheetAnyColumnToStringTest.suite());
    }
}

