/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet;

import adams.core.Utils;
import adams.core.exception.NotImplementedException;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetView;
import adams.env.Environment;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetViewTest
extends AdamsTestCase {
    public SpreadSheetViewTest(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/spreadsheet/data");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("sample.csv");
        this.m_TestHelper.copyResourceToTmp("sample2.csv");
        this.m_TestHelper.copyResourceToTmp("sample3.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("sample.csv");
        this.m_TestHelper.deleteFileFromTmp("sample2.csv");
        this.m_TestHelper.deleteFileFromTmp("sample3.csv");
        super.tearDown();
    }

    public void testRead() {
        SpreadSheet sheet = new CsvSpreadSheetReader().read(new TmpFile("sample.csv").getAbsolutePath());
        SpreadSheetView view = new SpreadSheetView(sheet, null, null);
        SpreadSheetViewTest.assertEquals((String)"# of columns differ", (int)3, (int)view.getColumnCount());
        SpreadSheetViewTest.assertEquals((String)"# of rows differ", (int)16, (int)view.getRowCount());
        view = new SpreadSheetView(sheet, new int[]{0, 2, 3, 4, 5, 8, 9, 10}, new int[]{0, 2});
        SpreadSheetViewTest.assertEquals((String)"# of columns differ", (int)2, (int)view.getColumnCount());
        SpreadSheetViewTest.assertEquals((String)"# of rows differ", (int)8, (int)view.getRowCount());
    }

    public void testInsertRow() {
        SpreadSheet sheet = new CsvSpreadSheetReader().read(new TmpFile("sample.csv").getAbsolutePath());
        sheet = new SpreadSheetView(sheet, null, null);
        try {
            sheet.insertRow(0);
        }
        catch (NotImplementedException notImplementedException) {
        }
        catch (Throwable t) {
            SpreadSheetViewTest.fail((String)("Failed to raise " + NotImplementedException.class.getName() + "!"));
        }
    }

    public void testRemoveRow() {
        SpreadSheet sheet = new CsvSpreadSheetReader().read(new TmpFile("sample.csv").getAbsolutePath());
        sheet = new SpreadSheetView(sheet, null, null);
        try {
            sheet.removeRow(0);
        }
        catch (NotImplementedException notImplementedException) {
        }
        catch (Throwable t) {
            SpreadSheetViewTest.fail((String)("Failed to raise " + NotImplementedException.class.getName() + "!"));
        }
    }

    public void testRemoveColumn() {
        SpreadSheet sheet = new CsvSpreadSheetReader().read(new TmpFile("sample.csv").getAbsolutePath());
        sheet = new SpreadSheetView(sheet, null, null);
        try {
            sheet.removeColumn(0);
        }
        catch (NotImplementedException notImplementedException) {
        }
        catch (Throwable t) {
            SpreadSheetViewTest.fail((String)("Failed to raise " + NotImplementedException.class.getName() + "!"));
        }
    }

    public void testRegression() {
        if (this.m_NoRegressionTest) {
            return;
        }
        SpreadSheet sheet = new CsvSpreadSheetReader().read(new TmpFile("sample.csv").getAbsolutePath());
        sheet = new SpreadSheetView(sheet, null, null);
        TmpFile output = new TmpFile("sample_out.csv");
        new CsvSpreadSheetWriter().write(sheet, output.getAbsolutePath());
        String regression = this.m_Regression.compare(new File[]{output.getAbsoluteFile()});
        SpreadSheetViewTest.assertNull((String)("Output differs:\n" + regression), (Object)regression);
    }

    public void testSort() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setDataRowType((DataRow)new DenseDataRow());
        SpreadSheet sheet = reader.read(new TmpFile("sample2.csv").getAbsolutePath());
        SpreadSheetView out = new SpreadSheetView(sheet, null, null);
        RowComparator comp = new RowComparator(new int[]{0});
        try {
            out.sort(comp);
        }
        catch (NotImplementedException notImplementedException) {
        }
        catch (Throwable t) {
            SpreadSheetViewTest.fail((String)("Failed to raise " + NotImplementedException.class.getName() + "!"));
        }
    }

    public void testSortUnique() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        reader.setDataRowType((DataRow)new DenseDataRow());
        SpreadSheet sheet = reader.read(new TmpFile("sample2.csv").getAbsolutePath());
        SpreadSheetView out = new SpreadSheetView(sheet, null, null);
        RowComparator comp = new RowComparator(new int[]{0});
        try {
            out.sort(comp, true);
        }
        catch (NotImplementedException notImplementedException) {
        }
        catch (Throwable t) {
            SpreadSheetViewTest.fail((String)("Failed to raise " + NotImplementedException.class.getName() + "!"));
        }
    }

    public void testCellValues() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet data = reader.read(new TmpFile("sample3.csv").getAbsolutePath());
        SpreadSheetView view = new SpreadSheetView(data, null, null);
        List values = view.getCellValues(0);
        SpreadSheetViewTest.assertEquals((String)"Number of values differs", (int)3, (int)values.size());
        SpreadSheetViewTest.assertEquals((String)"Value #1 differs", (String)"A", (String)((String)values.get(0)));
        SpreadSheetViewTest.assertEquals((String)"Value #2 differs", (String)"B", (String)((String)values.get(1)));
        SpreadSheetViewTest.assertEquals((String)"Value #3 differs", (String)"C", (String)((String)values.get(2)));
        values = view.getCellValues(view.getHeaderRow().getCellKey(0));
        SpreadSheetViewTest.assertEquals((String)"Number of values differs", (int)3, (int)values.size());
        SpreadSheetViewTest.assertEquals((String)"Value #1 differs", (String)"A", (String)((String)values.get(0)));
        SpreadSheetViewTest.assertEquals((String)"Value #2 differs", (String)"B", (String)((String)values.get(1)));
        SpreadSheetViewTest.assertEquals((String)"Value #3 differs", (String)"C", (String)((String)values.get(2)));
        view = new SpreadSheetView((SpreadSheet)view, new int[]{0, 3, 5, 6}, null);
        values = view.getCellValues(0);
        SpreadSheetViewTest.assertEquals((String)"Number of values differs", (int)3, (int)values.size());
        SpreadSheetViewTest.assertEquals((String)"Value #1 differs", (String)"A", (String)((String)values.get(0)));
        SpreadSheetViewTest.assertEquals((String)"Value #2 differs", (String)"B", (String)((String)values.get(1)));
        SpreadSheetViewTest.assertEquals((String)"Value #3 differs", (String)"C", (String)((String)values.get(2)));
        values = view.getCellValues(view.getHeaderRow().getCellKey(0));
        SpreadSheetViewTest.assertEquals((String)"Number of values differs", (int)3, (int)values.size());
        SpreadSheetViewTest.assertEquals((String)"Value #1 differs", (String)"A", (String)((String)values.get(0)));
        SpreadSheetViewTest.assertEquals((String)"Value #2 differs", (String)"B", (String)((String)values.get(1)));
        SpreadSheetViewTest.assertEquals((String)"Value #3 differs", (String)"C", (String)((String)values.get(2)));
    }

    public void testClear() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet data = reader.read(new TmpFile("sample3.csv").getAbsolutePath());
        data = new SpreadSheetView(data, null, null);
        try {
            data.clear();
        }
        catch (NotImplementedException notImplementedException) {
        }
        catch (Throwable t) {
            SpreadSheetViewTest.fail((String)("Failed to raise " + NotImplementedException.class.getName() + "!"));
        }
    }

    public void testSerializable() {
        CsvSpreadSheetReader reader = new CsvSpreadSheetReader();
        SpreadSheet data = reader.read(new TmpFile("sample3.csv").getAbsolutePath());
        SpreadSheetView view = new SpreadSheetView(data, null, null);
        SpreadSheetViewTest.assertNotNull((String)"Failed to serialize!", (Object)Utils.deepCopy((Object)view));
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetViewTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetViewTest.runTest((Test)SpreadSheetViewTest.suite());
    }
}

