/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.LookUpTable;
import adams.flow.source.Start;
import adams.flow.source.StringConstants;
import adams.flow.standalone.LookUpInit;
import adams.flow.transformer.LookUpAdd;
import adams.flow.transformer.StringSplit;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;

public class LookUpInitTest
extends AbstractFlowTest {
    public LookUpInitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv")});
    }

    public static Test suite() {
        return new TestSuite(LookUpInitTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            ArrayList<Object> actors = new ArrayList<Object>();
            LookUpInit lookupinit = new LookUpInit();
            actors.add(lookupinit);
            Start start = new Start();
            actors.add(start);
            Trigger trigger = new Trigger();
            AbstractArgumentOption argOption = (AbstractArgumentOption)trigger.getOptionManager().findByProperty("name");
            trigger.setName((String)argOption.valueOf("fill"));
            ArrayList<Object> actors2 = new ArrayList<Object>();
            StringConstants stringconstants = new StringConstants();
            argOption = (AbstractArgumentOption)stringconstants.getOptionManager().findByProperty("strings");
            ArrayList<BaseString> strings = new ArrayList<BaseString>();
            strings.add((BaseString)argOption.valueOf("a=hello"));
            strings.add((BaseString)argOption.valueOf("b=world"));
            strings.add((BaseString)argOption.valueOf("c=something completely different"));
            stringconstants.setStrings(strings.toArray(new BaseString[0]));
            actors2.add(stringconstants);
            StringSplit stringsplit = new StringSplit();
            argOption = (AbstractArgumentOption)stringsplit.getOptionManager().findByProperty("expression");
            stringsplit.setExpression((String)argOption.valueOf("="));
            actors2.add(stringsplit);
            LookUpAdd lookupadd = new LookUpAdd();
            actors2.add(lookupadd);
            trigger.setActors(actors2.toArray(new Actor[0]));
            actors.add(trigger);
            Trigger trigger2 = new Trigger();
            argOption = (AbstractArgumentOption)trigger2.getOptionManager().findByProperty("name");
            trigger2.setName((String)argOption.valueOf("output"));
            ArrayList<Object> actors3 = new ArrayList<Object>();
            LookUpTable lookuptable = new LookUpTable();
            actors3.add(lookuptable);
            DumpFile dumpfile = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile.getOptionManager().findByProperty("outputFile");
            dumpfile.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            actors3.add(dumpfile);
            trigger2.setActors(actors3.toArray(new Actor[0]));
            actors.add(trigger2);
            flow.setActors(actors.toArray(new Actor[0]));
            NullListener nulllistener = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener);
        }
        catch (Exception e) {
            LookUpInitTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        LookUpInitTest.runTest((Test)LookUpInitTest.suite());
    }
}

