/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractInPlaceSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.parser.SpreadSheetFormulaText;

public class SpreadSheetAddFormulaColumn
extends AbstractInPlaceSpreadSheetConversion {
    private static final long serialVersionUID = 3333030701857606514L;
    public static final String PLACEHOLDER_CURRENT_ROW = "@";
    public static final String PLACEHOLDER_LAST_COL = "#";
    public static final String PLACEHOLDER_LAST_ROW = "&";
    protected String m_Header;
    protected SpreadSheetFormulaText m_Formula;
    protected Range m_Rows;
    protected boolean m_ExpandVariables;

    public String globalInfo() {
        return "Adds a column with a user-supplied formula for the specified rows.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("header", "header", (Object)"Sum");
        this.m_OptionManager.add("formula", "formula", (Object)new SpreadSheetFormulaText("=sum(A@:#@)"));
        this.m_OptionManager.add("rows", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("expand-variables", "expandVariables", (Object)false);
    }

    public void setHeader(String value) {
        this.m_Header = value;
        this.reset();
    }

    public String getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The title of the formula column.";
    }

    public void setFormula(SpreadSheetFormulaText value) {
        this.m_Formula = value;
        this.reset();
    }

    public SpreadSheetFormulaText getFormula() {
        return this.m_Formula;
    }

    public String formulaTipText() {
        return "The formula to add (incl '='); use '@' as placeholder for the current row, '&' for the last row, '#' for the last column.";
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The range of rows to add the formula for.";
    }

    public void setExpandVariables(boolean value) {
        this.m_ExpandVariables = value;
        this.reset();
    }

    public boolean getExpandVariables() {
        return this.m_ExpandVariables;
    }

    public String expandVariablesTipText() {
        return "If enabled, any variables in the formula get expanded first before adding it to the spreadsheet.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        SpreadSheet result = this.m_NoCopy ? input : input.getClone();
        this.m_Rows.setMax(result.getRowCount());
        int[] rows = this.m_Rows.getIntIndices();
        result.insertColumn(result.getColumnCount(), this.m_Header);
        for (int i = 0; i < rows.length; ++i) {
            String formula = this.m_Formula.getValue();
            if (this.m_ExpandVariables) {
                formula = this.getOptionManager().getVariables().expand(formula);
            }
            formula = formula.replace(PLACEHOLDER_CURRENT_ROW, Integer.toString(rows[i] + 2));
            formula = formula.replace(PLACEHOLDER_LAST_ROW, Integer.toString(result.getRowCount() + 1));
            formula = formula.replace(PLACEHOLDER_LAST_COL, SpreadSheetUtils.getColumnPosition((int)(result.getColumnCount() - 2)));
            DataRow row = result.getRow(rows[i]);
            row.addCell(result.getColumnCount() - 1).setFormula(formula);
        }
        return result;
    }
}

