/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.base.BaseCharset;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.ChunkedSpreadSheetReader;
import adams.data.io.input.NoHeaderSpreadSheetReader;
import adams.data.io.output.SimpleStreamSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.List;

public class SimpleStreamSpreadSheetReader
extends AbstractSpreadSheetReader
implements NoHeaderSpreadSheetReader,
ChunkedSpreadSheetReader {
    private static final long serialVersionUID = -6855023352925257381L;
    protected boolean m_NoHeader;
    protected String m_CustomColumnHeaders;
    protected int m_ChunkSize;
    protected BufferedReader m_Reader;
    protected SpreadSheet m_Header;

    public String globalInfo() {
        return "Reads file in simple stream format:\n- one spreadsheet row per line in the output\n- cells are separated by TAB\n- cell format: '<1-based index>:<content-type ID>:<content>'\nNB: tabs, new lines etc in the content get backquoted.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", (Object)new BaseCharset());
        this.m_OptionManager.add("no-header", "noHeader", (Object)false);
        this.m_OptionManager.add("custom-column-headers", "customColumnHeaders", (Object)"");
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)-1, (Number)-1, null);
    }

    public void setNoHeader(boolean value) {
        this.m_NoHeader = value;
        this.reset();
    }

    public boolean getNoHeader() {
        return this.m_NoHeader;
    }

    public String noHeaderTipText() {
        return "If enabled, all rows get added as data rows and a dummy header will get inserted.";
    }

    public void setCustomColumnHeaders(String value) {
        this.m_CustomColumnHeaders = value;
        this.reset();
    }

    public String getCustomColumnHeaders() {
        return this.m_CustomColumnHeaders;
    }

    public String customColumnHeadersTipText() {
        return "The custom headers to use for the columns instead (comma-separated list); ignored if empty.";
    }

    public void setChunkSize(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ChunkSize = value;
        this.reset();
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The maximum number of rows per chunk; using -1 will read put all data into a single spreadsheet object.";
    }

    public SpreadSheetWriter getCorrespondingWriter() {
        return new SimpleStreamSpreadSheetWriter();
    }

    public String getFormatDescription() {
        return new SimpleStreamSpreadSheetWriter().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new SimpleStreamSpreadSheetWriter().getFormatExtensions();
    }

    protected AbstractSpreadSheetReader.InputType getInputType() {
        return AbstractSpreadSheetReader.InputType.READER;
    }

    protected SpreadSheet doRead(Reader r) {
        this.m_Header = null;
        this.m_Reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        return this.nextChunk();
    }

    public boolean hasMoreChunks() {
        return this.m_Reader != null;
    }

    protected String[] nextLine() throws Exception {
        if (this.m_Reader == null) {
            return null;
        }
        String line = this.m_Reader.readLine();
        if (line == null) {
            this.m_Reader = null;
            return null;
        }
        String[] result = line.split("\t");
        return result;
    }

    protected String[] splitCell(String cell) {
        String[] result = new String[3];
        int pos = cell.indexOf(":");
        result[0] = cell.substring(0, pos);
        int pos2 = cell.indexOf(":", pos + 1);
        result[1] = cell.substring(pos + 1, pos2);
        result[2] = cell.substring(pos2 + 1);
        return result;
    }

    public SpreadSheet nextChunk() {
        SpreadSheet result = null;
        try {
            String[] parts;
            int i;
            HeaderRow row;
            String[] cells = null;
            if (this.m_Header == null) {
                this.m_Header = this.m_SpreadSheetType.newInstance();
                this.m_Header.setDataRowClass(this.m_DataRowType.getClass());
                row = this.m_Header.getHeaderRow();
                if (!this.m_CustomColumnHeaders.isEmpty() || this.m_NoHeader) {
                    cells = this.nextLine();
                    List header = SpreadSheetUtils.createHeader((int)cells.length, (String)this.m_CustomColumnHeaders);
                    for (i = 0; i < header.size(); ++i) {
                        row.addCell("" + i).setContentAsString((String)header.get(i));
                    }
                    if (!this.m_NoHeader) {
                        cells = null;
                    }
                } else {
                    cells = this.nextLine();
                    for (i = 0; i < cells.length; ++i) {
                        parts = this.splitCell(cells[i]);
                        row.addCell("" + i).setContentAsString(parts[2]);
                    }
                    cells = null;
                }
            }
            result = this.m_Header.getHeader();
            boolean finished = false;
            int count = 0;
            while (!finished) {
                if (cells == null) {
                    cells = this.nextLine();
                }
                if (cells != null) {
                    ++count;
                    row = result.addRow();
                    for (i = 0; i < cells.length; ++i) {
                        parts = this.splitCell(cells[i]);
                        int index = Integer.parseInt(parts[0]) - 1;
                        Cell.ContentType type = Cell.ContentType.MISSING.parse(parts[1]);
                        if (type == null) {
                            row.addCell("" + index).setContent(parts[2]);
                            continue;
                        }
                        row.addCell("" + index).setContentAs(parts[2], type);
                    }
                    if (this.m_ChunkSize > 0 && count >= this.m_ChunkSize) {
                        finished = true;
                    }
                    cells = null;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.m_LastError = "Failed to read data!\n" + Utils.throwableToString((Throwable)e);
        }
        return result;
    }
}

