/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.cellfinder;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellLocation;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TypeRangeIterator
implements Iterator<CellLocation> {
    protected SpreadSheet m_Sheet;
    protected Row m_SheetRow;
    protected Cell.ContentType m_Type;
    protected int[] m_Rows;
    protected int[] m_Columns;
    protected int m_Row;
    protected int m_Column;
    protected boolean m_Finished;
    protected int[] m_Next;

    public TypeRangeIterator(SpreadSheet sheet, Cell.ContentType type, int[] rows, int[] cols) {
        this.m_Sheet = sheet;
        this.m_SheetRow = null;
        this.m_Type = type;
        this.m_Rows = (int[])rows.clone();
        this.m_Columns = (int[])cols.clone();
        this.m_Row = -1;
        this.m_Column = this.m_Columns.length - 1;
        this.m_Finished = false;
        this.m_Next = null;
    }

    public TypeRangeIterator(Row sheetRow, Cell.ContentType type, int[] cols) {
        this.m_Sheet = null;
        this.m_SheetRow = sheetRow;
        this.m_Type = type;
        this.m_Rows = null;
        this.m_Columns = (int[])cols.clone();
        this.m_Row = -1;
        this.m_Column = this.m_Columns.length - 1;
        this.m_Finished = false;
        this.m_Next = null;
    }

    protected void findNext() {
        if (this.m_Finished) {
            return;
        }
        while (!this.m_Finished && this.m_Next == null) {
            ++this.m_Column;
            if (this.m_Column == this.m_Columns.length) {
                ++this.m_Row;
                this.m_Column = 0;
            }
            if (this.m_Sheet != null) {
                if (this.m_Sheet.hasCell(this.m_Rows[this.m_Row], this.m_Columns[this.m_Column]) && this.m_Sheet.getCell(this.m_Rows[this.m_Row], this.m_Columns[this.m_Column]).getContentType() == this.m_Type) {
                    this.m_Next = new int[]{this.m_Rows[this.m_Row], this.m_Columns[this.m_Column]};
                }
            } else if (this.m_SheetRow != null && this.m_SheetRow.hasCell(this.m_Columns[this.m_Column]) && this.m_SheetRow.getCell(this.m_Columns[this.m_Column]).getContentType() == this.m_Type) {
                this.m_Next = new int[]{0, this.m_Columns[this.m_Column]};
            }
            boolean bl = this.m_Finished = this.m_Row == this.m_Rows.length - 1 && this.m_Column == this.m_Columns.length - 1;
            if (!this.m_Finished) continue;
            this.m_Sheet = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.m_Next == null) {
            this.findNext();
        }
        return this.m_Next != null;
    }

    @Override
    public CellLocation next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        CellLocation result = new CellLocation(this.m_Next[0], this.m_Next[1]);
        this.m_Next = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

