/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.filter;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.spreadsheet.filter.AbstractTrainableSpreadSheetFilter;
import adams.data.statistics.StatUtils;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Arrays;

public class Standardize
extends AbstractTrainableSpreadSheetFilter {
    private static final long serialVersionUID = 5377534668839214763L;
    protected SpreadSheetColumnRange m_Range;
    protected int[] m_Indices;
    protected boolean[] m_Numeric;
    protected double[] m_Means;
    protected double[] m_StdDevs;

    public String globalInfo() {
        return "Standardizes numeric columns to mean 0.0 and standard deviation 1.0.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("range", "range", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setRange(SpreadSheetColumnRange value) {
        this.m_Range = value;
        this.reset();
    }

    public SpreadSheetColumnRange getRange() {
        return this.m_Range;
    }

    public String rangeTipText() {
        return "The column range to standardize.";
    }

    @Override
    protected SpreadSheet doTrain(SpreadSheet data) throws Exception {
        this.m_Range.setData(data);
        this.m_Indices = this.m_Range.getIntIndices();
        this.m_Numeric = new boolean[data.getColumnCount()];
        Arrays.fill(this.m_Numeric, false);
        for (int index : this.m_Indices) {
            if (!data.isNumeric(index)) continue;
            this.m_Numeric[index] = true;
        }
        this.m_Means = new double[data.getColumnCount()];
        this.m_StdDevs = new double[data.getColumnCount()];
        Arrays.fill(this.m_Means, Double.NaN);
        Arrays.fill(this.m_StdDevs, Double.NaN);
        TDoubleArrayList values = new TDoubleArrayList();
        for (int index : this.m_Indices) {
            if (!this.m_Numeric[index]) continue;
            double[] allValues = SpreadSheetUtils.getNumericColumn((SpreadSheet)data, (int)index);
            values.clear();
            for (double v : allValues) {
                if (Double.isNaN(v)) continue;
                values.add(v);
            }
            this.m_Means[index] = StatUtils.mean((double[])values.toArray());
            this.m_StdDevs[index] = StatUtils.stddev((double[])values.toArray(), (boolean)true);
            if (!Double.isNaN(this.m_Means[index])) continue;
            this.m_Numeric[index] = false;
        }
        return this.doFilter(data);
    }

    @Override
    protected SpreadSheet doFilter(SpreadSheet data) throws Exception {
        SpreadSheet result = data.getClone();
        for (Row row : result.rows()) {
            for (int index : this.m_Indices) {
                Cell cell;
                if (!this.m_Numeric[index] || !row.hasCell(index) || (cell = row.getCell(index)).isMissing()) continue;
                if (this.m_StdDevs[index] == 0.0) {
                    cell.setContent(Double.valueOf(cell.toDouble() - this.m_Means[index]));
                    continue;
                }
                cell.setContent(Double.valueOf((cell.toDouble() - this.m_Means[index]) / this.m_StdDevs[index]));
            }
        }
        return result;
    }
}

