/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.AbstractTrainableRowFinder;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.data.spreadsheet.rowfinder.TrainableRowFinder;
import java.util.Arrays;
import java.util.HashSet;

public class MultiRowFinder
extends AbstractTrainableRowFinder {
    private static final long serialVersionUID = 1441664440186470414L;
    protected RowFinder[] m_Finders;
    protected Combination m_Combination;

    public String globalInfo() {
        return "Applies multiple row finding algorithms to the data.\nThe indices can be either joined or intersected.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finders", (Object)new RowFinder[0]);
        this.m_OptionManager.add("combination", "combination", (Object)Combination.JOIN);
    }

    public void setFinders(RowFinder[] value) {
        this.m_Finders = value;
        this.reset();
    }

    public RowFinder[] getFinders() {
        return this.m_Finders;
    }

    public String findersTipText() {
        return "The row finders to use.";
    }

    public void setCombination(Combination value) {
        this.m_Combination = value;
        this.reset();
    }

    public Combination getCombination() {
        return this.m_Combination;
    }

    public String combinationTipText() {
        return "Defines how the indices are combined.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"combination", (Object)((Object)this.m_Combination), (String)"combination: ");
    }

    @Override
    protected boolean doTrainRowFinder(SpreadSheet data) {
        boolean result = true;
        for (int i = 0; i < this.m_Finders.length && (!(this.m_Finders[i] instanceof TrainableRowFinder) || (result = ((TrainableRowFinder)this.m_Finders[i]).trainRowFinder(data))); ++i) {
        }
        return result;
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        int i;
        HashSet<Integer> all = new HashSet<Integer>();
        block4: for (i = 0; i < this.m_Finders.length; ++i) {
            int[] indicesArray = this.m_Finders[i].findRows(data);
            if (i == 0) {
                all.addAll(MultiRowFinder.arrayToHashSet(indicesArray));
                continue;
            }
            switch (this.m_Combination) {
                case JOIN: {
                    all.addAll(MultiRowFinder.arrayToHashSet(indicesArray));
                    continue block4;
                }
                case INTERSECT: {
                    HashSet<Integer> indices = MultiRowFinder.arrayToHashSet(indicesArray);
                    all.retainAll(indices);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Unhandled combination: " + (Object)((Object)this.m_Combination));
                }
            }
        }
        int[] result = new int[all.size()];
        if (result.length > 0) {
            i = 0;
            for (Integer index : all) {
                result[i] = index;
                ++i;
            }
            Arrays.sort(result);
        }
        return result;
    }

    public static enum Combination {
        JOIN,
        INTERSECT;

    }
}

