/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;

public class SpreadSheetCellSelectionContainer
extends AbstractContainer {
    private static final long serialVersionUID = -383683828748866169L;
    public static final String VALUE_ORIGINAL = "Original";
    public static final String VALUE_SELECTED = "Selected";
    public static final String VALUE_SUBSET = "Subset";

    public SpreadSheetCellSelectionContainer() {
        this(null, null, null);
    }

    public SpreadSheetCellSelectionContainer(SpreadSheet original, SpreadSheet selected, SpreadSheet subset) {
        this.setValue(VALUE_ORIGINAL, original);
        this.setValue(VALUE_SELECTED, selected);
        this.setValue(VALUE_SUBSET, subset);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_ORIGINAL);
        result.add(VALUE_SELECTED);
        result.add(VALUE_SUBSET);
        return result.iterator();
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_ORIGINAL, "original spreadsheet", SpreadSheet.class);
        this.addHelp(VALUE_SELECTED, "spreadsheet with coordinates of selected cells and associated values", SpreadSheet.class);
        this.addHelp(VALUE_SUBSET, "spreadsheet with only the selected values present", SpreadSheet.class);
    }

    public boolean isValid() {
        return this.hasValue(VALUE_ORIGINAL) && this.hasValue(VALUE_SELECTED) && this.hasValue(VALUE_SUBSET);
    }
}

