/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.core.QuickInfoHelper;
import adams.core.io.ConsoleHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.io.output.NullWriter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.AbstractTextualDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.UpdateableDisplayPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetColumnComboBox;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.CellRenderingCustomizer;
import adams.gui.core.spreadsheettable.DefaultCellRenderingCustomizer;
import adams.gui.core.spreadsheettable.ProcessSelectedRows;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.visualization.core.PopupMenuCustomizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SpreadSheetDisplay
extends AbstractTextualDisplay
implements DisplayPanelProvider,
SpreadSheetSupporter {
    private static final long serialVersionUID = 3247255046513744115L;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetTableModel m_TableModel;
    protected SearchPanel m_PanelSearch;
    protected int m_NumDecimals;
    protected CellRenderingCustomizer m_CellRenderingCustomizer;
    protected boolean m_ShowFormulas;
    protected boolean m_AllowSearch;
    protected boolean m_OptimalColumnWidth;
    protected boolean m_ReadOnly;
    protected ProcessSelectedRows[] m_SelectedRowsProcessors;

    public String globalInfo() {
        return "Actor for displaying a spreadsheet.\nCustom background for negative/positive values can be specified as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)3, (Number)-1, null);
        this.m_OptionManager.add("cell-rendering-customizer", "cellRenderingCustomizer", (Object)new DefaultCellRenderingCustomizer());
        this.m_OptionManager.add("show-formulas", "showFormulas", (Object)false);
        this.m_OptionManager.add("allow-search", "allowSearch", (Object)false);
        this.m_OptionManager.add("optimal-column-width", "optimalColumnWidth", (Object)true);
        this.m_OptionManager.add("read-only", "readOnly", (Object)true);
        this.m_OptionManager.add("writer", "writer", (Object)new NullWriter());
        this.m_OptionManager.add("selected-rows-processor", "selectedRowsProcessors", (Object)new ProcessSelectedRows[0]);
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numDecimals", (Object)this.m_NumDecimals, (String)", decimals: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"cellRenderingCustomizer", (Object)this.m_CellRenderingCustomizer, (String)", rendering: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"showFormulas", (boolean)this.m_ShowFormulas, (String)"formulas", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"allowSearch", (boolean)this.m_AllowSearch, (String)"searchable", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"optimalColumnWidth", (boolean)this.m_OptimalColumnWidth, (String)"optimal", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"readOnly", (boolean)this.m_ReadOnly, (String)"read-only", (String)", ");
        return result;
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values.";
    }

    public void setCellRenderingCustomizer(CellRenderingCustomizer value) {
        this.m_CellRenderingCustomizer = value;
        this.reset();
    }

    public CellRenderingCustomizer getCellRenderingCustomizer() {
        return this.m_CellRenderingCustomizer;
    }

    public String cellRenderingCustomizerTipText() {
        return "The customizer for the cell rendering.";
    }

    public void setShowFormulas(boolean value) {
        this.m_ShowFormulas = value;
        this.reset();
    }

    public boolean getShowFormulas() {
        return this.m_ShowFormulas;
    }

    public String showFormulasTipText() {
        return "Whether to show the formulas or the calculated values.";
    }

    public void setAllowSearch(boolean value) {
        this.m_AllowSearch = value;
        this.reset();
    }

    public boolean getAllowSearch() {
        return this.m_AllowSearch;
    }

    public String allowSearchTipText() {
        return "Whether to allow the user to search the table.";
    }

    public void setOptimalColumnWidth(boolean value) {
        this.m_OptimalColumnWidth = value;
        this.reset();
    }

    public boolean getOptimalColumnWidth() {
        return this.m_OptimalColumnWidth;
    }

    public String optimalColumnWidthTipText() {
        return "Whether to calculate the optimal column width whenever a token is displayed (= enabled) or only when flow finishes.";
    }

    public void setReadOnly(boolean value) {
        this.m_ReadOnly = value;
        this.reset();
    }

    public boolean getReadOnly() {
        return this.m_ReadOnly;
    }

    public String readOnlyTipText() {
        return "Whether cells are read-only or editable.";
    }

    public void setSelectedRowsProcessors(ProcessSelectedRows[] value) {
        this.m_SelectedRowsProcessors = value;
        this.reset();
    }

    public ProcessSelectedRows[] getSelectedRowsProcessors() {
        return this.m_SelectedRowsProcessors;
    }

    public String selectedRowsProcessorsTipText() {
        return "The schemes that allow processing of the selected rows.";
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void clearPanel() {
        this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)new DefaultSpreadSheet());
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
    }

    public BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)new DefaultSpreadSheet());
        this.m_TableModel.setReadOnly(this.m_ReadOnly);
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
        this.m_Table.setFont(this.m_Font);
        this.m_Table.setUseOptimalColumnWidths(this.m_OptimalColumnWidth);
        result.add((Component)new BaseScrollPane((Component)this.m_Table), (Object)"Center");
        JPanel panel = new JPanel(new FlowLayout(2));
        SpreadSheetColumnComboBox columnCombo = new SpreadSheetColumnComboBox(this.m_Table);
        panel.add((Component)columnCombo);
        result.add((Component)panel, (Object)"North");
        this.m_PanelSearch = null;
        if (this.m_AllowSearch) {
            this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
            this.m_PanelSearch.addSearchListener(new SearchListener(){

                public void searchInitiated(SearchEvent e) {
                    SpreadSheetDisplay.this.m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                }
            });
            result.add((Component)this.m_PanelSearch, (Object)"South");
        }
        if (this.m_SelectedRowsProcessors.length > 0) {
            PopupMenuCustomizer customizer = new PopupMenuCustomizer(){

                public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
                    int[] rows = SpreadSheetDisplay.this.m_Table.getSelectedRows().length == 0 ? new int[]{SpreadSheetDisplay.this.m_Table.rowAtPoint(e.getPoint())} : SpreadSheetDisplay.this.m_Table.getSelectedRows();
                    int[] actRows = new int[rows.length];
                    for (int i = 0; i < rows.length; ++i) {
                        actRows[i] = SpreadSheetDisplay.this.m_Table.getActualRow(rows[i]);
                    }
                    SpreadSheetTablePopupMenuItemHelper.addProcessSelectedRowsToPopupMenu((SpreadSheetTable)SpreadSheetDisplay.this.m_Table, (JPopupMenu)menu, (int[])actRows, (int[])rows, Arrays.asList(SpreadSheetDisplay.this.m_SelectedRowsProcessors));
                }
            };
            this.m_Table.setCellPopupMenuCustomizer(customizer);
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected void display(Token token) {
        this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
        this.m_TableModel.setReadOnly(this.m_ReadOnly);
        this.m_Table.setModel((TableModel)this.m_TableModel);
        this.m_Table.setNumDecimals(this.m_NumDecimals);
        this.m_Table.setCellRenderingCustomizer((CellRenderingCustomizer)OptionUtils.shallowCopy((Object)this.m_CellRenderingCustomizer));
        this.m_Table.setShowFormulas(this.m_ShowFormulas);
        this.m_Table.setUseOptimalColumnWidths(this.m_OptimalColumnWidth);
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        SpreadSheetDisplayPanel result = new SpreadSheetDisplayPanel(this);
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    protected String doExecute() {
        String result = null;
        if (this.isHeadless()) {
            ConsoleHelper.printlnOut((String)("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n"));
            ConsoleHelper.printlnOut((String)("" + this.m_InputToken.getPayload()));
        } else {
            result = super.doExecute();
        }
        return result;
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return ExtensionFileFilter.getCsvFileFilter();
    }

    public String supplyText() {
        String result = null;
        if (this.m_TableModel != null) {
            result = this.m_TableModel.toSpreadSheet().toString();
        }
        return result;
    }

    public Class[] getSendToClasses() {
        ArrayList<Class> result = new ArrayList<Class>(Arrays.asList(super.getSendToClasses()));
        if (!result.contains(JTable.class)) {
            result.add(JTable.class);
        }
        if (!result.contains(SpreadSheetTable.class)) {
            result.add(SpreadSheetTable.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(SpreadSheetTable.class, (Class[])cls)) {
            result = this.m_Table;
            if (this.m_Table.getRowCount() == 0) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_Table;
            if (this.m_Table.getRowCount() == 0) {
                result = null;
            }
        } else {
            result = super.getSendToItem(cls);
        }
        return result;
    }

    public SpreadSheet toSpreadSheet() {
        if (this.m_Table != null) {
            return this.m_Table.toSpreadSheet(TableRowRange.VISIBLE);
        }
        return null;
    }

    public void wrapUp() {
        if (this.m_Table != null && !this.m_OptimalColumnWidth) {
            this.m_Table.setUseOptimalColumnWidths(true);
        }
        super.wrapUp();
    }

    public static class SpreadSheetDisplayPanel
    extends AbstractTextDisplayPanel
    implements UpdateableDisplayPanel {
        private static final long serialVersionUID = 3524967045456783678L;
        protected SpreadSheetDisplay m_Owner;
        protected SpreadSheetTable m_Table;
        protected SpreadSheetTableModel m_TableModel;
        protected SearchPanel m_PanelSearch;

        public SpreadSheetDisplayPanel(SpreadSheetDisplay owner) {
            super(((Object)((Object)owner)).getClass().getName());
            this.m_Owner = owner;
            this.initGUI();
        }

        protected void initGUI() {
            if (this.m_Owner == null) {
                return;
            }
            super.initGUI();
            this.setLayout(new BorderLayout());
            this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)new DefaultSpreadSheet());
            this.m_TableModel.setReadOnly(this.m_Owner.getReadOnly());
            this.m_Table = new SpreadSheetTable(this.m_TableModel);
            this.m_Table.setUseOptimalColumnWidths(this.m_Owner.getOptimalColumnWidth());
            this.m_Table.setFont(this.m_Owner.getFont());
            this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
            JPanel panel = new JPanel(new FlowLayout(2));
            SpreadSheetColumnComboBox columnCombo = new SpreadSheetColumnComboBox(this.m_Table);
            panel.add((Component)columnCombo);
            this.add(panel, "North");
            this.m_PanelSearch = null;
            if (this.m_Owner.getAllowSearch()) {
                this.m_PanelSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true);
                this.m_PanelSearch.addSearchListener(new SearchListener(){

                    public void searchInitiated(SearchEvent e) {
                        m_Table.search(e.getParameters().getSearchString(), e.getParameters().isRegExp());
                    }
                });
                this.add((Component)this.m_PanelSearch, "South");
            }
            if (this.m_Owner.getSelectedRowsProcessors().length > 0) {
                PopupMenuCustomizer customizer = new PopupMenuCustomizer(){

                    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
                        int[] rows = m_Table.getSelectedRows().length == 0 ? new int[]{m_Table.rowAtPoint(e.getPoint())} : m_Table.getSelectedRows();
                        int[] actRows = new int[rows.length];
                        for (int i = 0; i < rows.length; ++i) {
                            actRows[i] = m_Table.getActualRow(rows[i]);
                        }
                        SpreadSheetTablePopupMenuItemHelper.addProcessSelectedRowsToPopupMenu((SpreadSheetTable)m_Table, (JPopupMenu)menu, (int[])actRows, (int[])rows, Arrays.asList(m_Owner.getSelectedRowsProcessors()));
                    }
                };
                this.m_Table.setCellPopupMenuCustomizer(customizer);
            }
        }

        public void display(Token token) {
            this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
            this.m_TableModel.setReadOnly(this.m_Owner.getReadOnly());
            this.m_Table.setModel((TableModel)this.m_TableModel);
            this.m_Table.setNumDecimals(this.m_Owner.getNumDecimals());
            this.m_Table.setCellRenderingCustomizer((CellRenderingCustomizer)OptionUtils.shallowCopy((Object)this.m_Owner.getCellRenderingCustomizer()));
            this.m_Table.setShowFormulas(this.m_Owner.getShowFormulas());
            this.m_Table.setUseOptimalColumnWidths(this.m_Owner.getOptimalColumnWidth());
        }

        public Token getUpdatedToken() {
            return new Token((Object)this.m_TableModel.toSpreadSheet());
        }

        public ExtensionFileFilter getCustomTextFileFilter() {
            return ExtensionFileFilter.getCsvFileFilter();
        }

        public String supplyText() {
            return this.m_TableModel.toSpreadSheet().toString();
        }

        public void clearPanel() {
            this.m_TableModel = new SpreadSheetTableModel();
            this.m_Table.setModel((TableModel)this.m_TableModel);
        }

        public void cleanUp() {
        }
    }
}

