/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.MessageCollection;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.chooser.BaseDirectoryChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractProcessSelectedRows;
import java.awt.Component;
import java.io.File;

public class CopySelectedFiles
extends AbstractProcessSelectedRows {
    private static final long serialVersionUID = 7786133414905315983L;
    protected SpreadSheetColumnIndex m_Column;
    protected PlaceholderDirectory m_TargetDir;
    protected BaseDirectoryChooser m_TargetChooser;

    public String globalInfo() {
        return "Allows the user to copy the selected files in the specified column.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("column", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("target-dir", "targetDir", (Object)new PlaceholderDirectory());
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column with the file names.";
    }

    public void setTargetDir(PlaceholderDirectory value) {
        this.m_TargetDir = value;
        this.reset();
    }

    public PlaceholderDirectory getTargetDir() {
        return this.m_TargetDir;
    }

    public String targetDirTipText() {
        return "The initial target directory for the copy operation.";
    }

    public String getIconName() {
        return "copy.gif";
    }

    public int minNumRows() {
        return 1;
    }

    public int maxNumRows() {
        return -1;
    }

    protected String getDefaultMenuItem() {
        return "Copy selected file(s)";
    }

    protected boolean doProcessSelectedRows(SpreadSheetTable table, SpreadSheet sheet, int[] actRows, int[] selRows) {
        int retVal;
        this.m_Column.setData(sheet);
        int col = this.m_Column.getIntIndex();
        if (col == -1) {
            GUIHelper.showErrorMessage((Component)table.getParent(), (String)("Failed to locate column:" + (Object)((Object)this.m_Column)));
            return false;
        }
        if (this.m_TargetChooser == null) {
            this.m_TargetChooser = new BaseDirectoryChooser();
            this.m_TargetChooser.setSelectedFile((File)this.m_TargetDir);
            this.m_TargetChooser.setDialogTitle(this.getMenuItem());
        }
        if ((retVal = this.m_TargetChooser.showOpenDialog((Component)table.getParent())) != 0) {
            return false;
        }
        PlaceholderDirectory targetDir = this.m_TargetChooser.getSelectedDirectory();
        MessageCollection errors = new MessageCollection();
        for (int row : actRows) {
            PlaceholderFile sourceFile = new PlaceholderFile(sheet.getCell(row, col).toString());
            try {
                if (FileUtils.copy((File)sourceFile, (File)targetDir)) continue;
                errors.add("Failed to copy '" + sourceFile + "' to '" + targetDir + "'!");
            }
            catch (Exception e) {
                errors.add("Failed to copy '" + sourceFile + "' to '" + targetDir + "'!", (Throwable)e);
            }
        }
        if (!errors.isEmpty()) {
            GUIHelper.showErrorMessage((Component)table.getParent(), (String)("Failed to copy files:\n" + errors));
        }
        return errors.isEmpty();
    }
}

